/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;

public class FlexAdapter
extends LexerBase {
    private FlexLexer myFlex = null;
    private IElementType myTokenType = null;
    private CharSequence myText;
    private int myEnd;
    private int myState;

    public FlexAdapter(FlexLexer flex) {
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    public void start(char[] buffer, int startOffset, int endOffset, int initialState) {
        CharArrayCharSequence arrayCharSequence = new CharArrayCharSequence(buffer);
        this.start(arrayCharSequence, startOffset, endOffset, initialState);
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myText = buffer;
        this.myEnd = endOffset;
        try {
            this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        }
        catch (AbstractMethodError ame) {
            this.myFlex.reset(this.myText.subSequence(startOffset, endOffset), initialState);
        }
        this.myTokenType = null;
    }

    public int getState() {
        this.locateToken();
        return this.myState;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myFlex.getTokenStart();
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myFlex.getTokenEnd();
    }

    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    public char[] getBuffer() {
        return CharArrayUtil.fromSequence(this.myText);
    }

    public CharSequence getBufferSequence() {
        return this.myText;
    }

    public int getBufferEnd() {
        return this.myEnd;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

