/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class FilterLexer
extends LexerBase {
    private Lexer myOriginal;
    private Filter myFilter;
    private boolean[] myStateFilter;
    private int myPrevTokenEnd;

    public FilterLexer(Lexer original, Filter filter, boolean[] stateFilter) {
        this.myOriginal = original;
        this.myFilter = filter;
        this.myStateFilter = stateFilter;
    }

    public FilterLexer(Lexer original, Filter filter) {
        this(original, filter, null);
    }

    public Lexer getOriginal() {
        return this.myOriginal;
    }

    public void start(char[] buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
        this.myPrevTokenEnd = -1;
        this.locateToken();
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
        this.myPrevTokenEnd = -1;
        this.locateToken();
    }

    public CharSequence getBufferSequence() {
        return this.myOriginal.getBufferSequence();
    }

    public int getState() {
        return this.myOriginal.getState();
    }

    public IElementType getTokenType() {
        return this.myOriginal.getTokenType();
    }

    public int getTokenStart() {
        return this.myOriginal.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myOriginal.getTokenEnd();
    }

    public char[] getBuffer() {
        return this.myOriginal.getBuffer();
    }

    public int getBufferEnd() {
        return this.myOriginal.getBufferEnd();
    }

    public void advance() {
        this.myPrevTokenEnd = this.myOriginal.getTokenEnd();
        this.myOriginal.advance();
        this.locateToken();
    }

    public int getPrevTokenEnd() {
        return this.myPrevTokenEnd;
    }

    public LexerPosition getCurrentPosition() {
        return this.myOriginal.getCurrentPosition();
    }

    public void restore(LexerPosition position) {
        this.myOriginal.restore(position);
        this.myPrevTokenEnd = -1;
    }

    public final void locateToken() {
        IElementType tokenType;
        while ((tokenType = this.myOriginal.getTokenType()) != null && (this.myFilter != null && this.myFilter.reject(tokenType) || this.myStateFilter != null && this.myStateFilter[this.myOriginal.getState()])) {
            this.myOriginal.advance();
        }
    }

    public static final class SetFilter
    implements Filter {
        private TokenSet mySet;

        public SetFilter(TokenSet set) {
            this.mySet = set;
        }

        public boolean reject(IElementType type) {
            return this.mySet.contains(type);
        }
    }

    public static interface Filter {
        public boolean reject(IElementType var1);
    }
}

