/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesElementFactory {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Property createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.createProperty must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.createProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.createProperty must not be null");
        }
        String text = PropertiesElementFactory.escape(name) + "=" + value;
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        Property property = dummyFile.getProperties().get(0);
        if (property == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/PropertiesElementFactory.createProperty must not return null");
        }
        return property;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.createPropertiesFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.createPropertiesFile must not be null");
        }
        String filename = "dummy." + StdFileTypes.PROPERTIES.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiManager.getInstance(project).getElementFactory().createFileFromText(filename, StdLanguages.PROPERTIES.getAssociatedFileType(), (CharSequence)text);
        if (propertiesFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/PropertiesElementFactory.createPropertiesFile must not return null");
        }
        return propertiesFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String escape(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.escape must not be null");
        }
        if (StringUtil.startsWithChar(name, '#')) {
            name = PropertiesElementFactory.escapeChar(name, '#');
        }
        if (StringUtil.startsWithChar(name, '!')) {
            name = PropertiesElementFactory.escapeChar(name, '!');
        }
        name = PropertiesElementFactory.escapeChar(name, '=');
        name = PropertiesElementFactory.escapeChar(name, ':');
        name = PropertiesElementFactory.escapeChar(name, ' ');
        String string = name = PropertiesElementFactory.escapeChar(name, '\t');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/PropertiesElementFactory.escape must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String escapeChar(@NotNull String name, char c) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/PropertiesElementFactory.escapeChar must not be null");
        }
        int offset = 0;
        while (true) {
            int i;
            if ((i = name.indexOf(c, offset)) == -1) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/PropertiesElementFactory.escapeChar must not return null");
                }
                return string;
            }
            if (i == 0 || name.charAt(i - 1) != '\\') {
                name = name.substring(0, i) + '\\' + name.substring(i);
            }
            offset = i + 2;
        }
    }
}

