/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.injection;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class InjectedLanguageManager
implements ProjectComponent {
    public static final ExtensionPointName<ConcatenationAwareInjector> CONCATENATION_INJECTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.concatenationAwareInjector");
    public static final ExtensionPointName<MultiHostInjector> MULTIHOST_INJECTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.multiHostInjector");

    public static InjectedLanguageManager getInstance(Project project) {
        return project.getComponent(InjectedLanguageManager.class);
    }

    public abstract PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement var1);

    public abstract TextRange injectedToHost(@NotNull PsiElement var1, @NotNull TextRange var2);

    public abstract void registerMultiHostInjector(@NotNull MultiHostInjector var1);

    public abstract boolean unregisterMultiHostInjector(@NotNull MultiHostInjector var1);

    public abstract void registerConcatenationInjector(@NotNull ConcatenationAwareInjector var1);

    public abstract boolean unregisterConcatenationInjector(@NotNull ConcatenationAwareInjector var1);

    public abstract String getUnescapedText(@NotNull PsiElement var1);
}

