/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CompositeDocumentationProvider
implements DocumentationProvider {
    private final Set<DocumentationProvider> myProviders;

    public CompositeDocumentationProvider(DocumentationProvider ... documentationProviders) {
        this.myProviders = new HashSet<DocumentationProvider>(Arrays.asList(documentationProviders));
    }

    public void inject(DocumentationProvider provider) {
        this.myProviders.add(provider);
    }

    public void remove(DocumentationProvider provider) {
        this.myProviders.remove(provider);
    }

    public String getQuickNavigateInfo(PsiElement element) {
        for (DocumentationProvider provider : this.myProviders) {
            String result = provider.getQuickNavigateInfo(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getUrlFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.myProviders) {
            String result = provider.getUrlFor(element, originalElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.myProviders) {
            String result = provider.generateDoc(element, originalElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        for (DocumentationProvider provider : this.myProviders) {
            PsiElement result = provider.getDocumentationElementForLookupItem(psiManager, object, element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        for (DocumentationProvider provider : this.myProviders) {
            PsiElement result = provider.getDocumentationElementForLink(psiManager, link, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

