/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWordsScanner
implements WordsScanner {
    private Lexer myLexer;
    private TokenSet myIdentifierTokenSet;
    private TokenSet myCommentTokenSet;
    private TokenSet myLiteralTokenSet;
    private boolean myMayHaveFileRefsInLiterals;

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet) {
        this.myLexer = lexer;
        this.myIdentifierTokenSet = identifierTokenSet;
        this.myCommentTokenSet = commentTokenSet;
        this.myLiteralTokenSet = literalTokenSet;
    }

    @Override
    public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
        this.myLexer.start(fileText, 0, fileText.length(), 0);
        WordOccurrence occurence = null;
        while (this.myLexer.getTokenType() != null) {
            IElementType type = this.myLexer.getTokenType();
            if (this.myIdentifierTokenSet.contains(type)) {
                if (occurence == null) {
                    occurence = new WordOccurrence(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                } else {
                    occurence.init(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                }
                if (!processor.process(occurence)) {
                    return;
                }
            } else if (this.myCommentTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.COMMENTS, occurence, false) : this.myLiteralTokenSet.contains(type) && !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.LITERALS, occurence, this.myMayHaveFileRefsInLiterals)) {
                return;
            }
            this.myLexer.advance();
        }
    }

    private static boolean stripWords(Processor<WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, WordOccurrence occurence, boolean mayHaveFileRefs) {
        int index = from;
        while (index != to) {
            char c;
            char c2 = tokenText.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || Character.isJavaIdentifierStart(c2) && c2 != '$')) {
                ++index;
                continue;
            }
            int index1 = index;
            while (++index != to && ((c = tokenText.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c) && c != '$')) {
            }
            if (occurence == null) {
                occurence = new WordOccurrence(tokenText, index1, index, kind);
            } else {
                occurence.init(tokenText, index1, index, kind);
            }
            if (!processor.process(occurence)) {
                return false;
            }
            if (!mayHaveFileRefs) continue;
            occurence.init(tokenText, index1, index, WordOccurrence.Kind.FOREIGN_LANGUAGE);
            if (processor.process(occurence)) continue;
            return false;
        }
        return true;
    }

    public void setMayHaveFileRefsInLiterals(boolean mayHaveFileRefsInLiterals) {
        this.myMayHaveFileRefsInLiterals = mayHaveFileRefsInLiterals;
    }
}

