/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Annotation {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final String myMessage;
    private ProblemHighlightType myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes = null;
    private Boolean myNeedsUpdateOnTyping = null;
    private String myTooltip;
    private boolean myAfterEndOfLine = false;
    private boolean myIsFileLevelAnnotation = false;
    private GutterIconRenderer myGutterIconRenderer;

    public Annotation(int startOffset, int endOffset, HighlightSeverity severity, String message, String tooltip) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    public void registerFix(IntentionAction fix) {
        this.registerFix(fix, null);
    }

    public void registerFix(IntentionAction fix, TextRange range) {
        this.registerFix(fix, range, null);
    }

    @Deprecated
    public void registerFix(IntentionAction fix, TextRange range, List<IntentionAction> options, String displayName) {
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(fix, range, options, displayName));
    }

    public void registerFix(IntentionAction fix, TextRange range, HighlightDisplayKey key) {
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(fix, range, key));
    }

    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            return this.myEnforcedAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            if (this.mySeverity == HighlightSeverity.ERROR) {
                return CodeInsightColors.ERRORS_ATTRIBUTES;
            }
            if (this.mySeverity == HighlightSeverity.WARNING) {
                return CodeInsightColors.WARNINGS_ATTRIBUTES;
            }
            if (this.mySeverity == HighlightSeverity.INFO) {
                return CodeInsightColors.INFO_ATTRIBUTES;
            }
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            return CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
        }
        return HighlighterColors.TEXT;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setHighlightType(ProblemHighlightType highlightType) {
        this.myHighlightType = highlightType;
    }

    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    public String toString() {
        return "Annotation(message='" + this.myMessage + "'" + ", severity='" + this.mySeverity + "'" + ", toolTip='" + this.myTooltip + "'" + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuickFixInfo {
        public final IntentionAction quickFix;
        public final TextRange textRange;
        public List<IntentionAction> options;
        @Deprecated
        public final String displayName;
        public HighlightDisplayKey key;

        @Deprecated
        public QuickFixInfo(IntentionAction quickFix, TextRange textRange, List<IntentionAction> options, String displayName) {
            this(quickFix, textRange, null);
            this.options = options;
        }

        public QuickFixInfo(IntentionAction fix, TextRange range, HighlightDisplayKey key) {
            this.key = key;
            this.quickFix = fix;
            this.textRange = range;
            this.displayName = key != null ? HighlightDisplayKey.getDisplayNameByKey(key) : fix.getText();
        }
    }
}

