/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.AnnotatorEP;
import com.intellij.lang.Commenter;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.LanguageDialect;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiReferenceAdjuster;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.refactoring.DefaultRefactoringSupportProvider;
import com.intellij.lang.refactoring.JavaNamesValidator;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.SmartExtensionPoint;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.TokenSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Language {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.Language");
    private static final SurroundDescriptor[] EMPTY_SURROUND_DESCRIPTORS_ARRAY = new SurroundDescriptor[0];
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = new HashMap<Class<? extends Language>, Language>();
    private final String myID;
    private final String[] myMimeTypes;
    public static final Language ANY = new Language("", new String[]{""}){};
    private static final EmptyFindUsagesProvider EMPTY_FIND_USAGES_PROVIDER = new EmptyFindUsagesProvider();
    private final NotNullLazyValue<SmartExtensionPoint<AnnotatorEP, Annotator>> myAnnotatorsSmartEP = new NotNullLazyValue<SmartExtensionPoint<AnnotatorEP, Annotator>>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected SmartExtensionPoint<AnnotatorEP, Annotator> compute() {
            SmartExtensionPoint<AnnotatorEP, Annotator> smartExtensionPoint = new SmartExtensionPoint<AnnotatorEP, Annotator>((Collection)new THashSet()){

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                protected ExtensionPoint<AnnotatorEP> getExtensionPoint() {
                    ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(AnnotatorEP.EP_NAME);
                    if (extensionPoint == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/lang/Language$2$1.getExtensionPoint must not return null");
                    }
                    return extensionPoint;
                }

                protected Annotator getExtension(@NotNull AnnotatorEP ep) {
                    if (ep == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language$2$1.getExtension must not be null");
                    }
                    if (ep.language.equals(Language.this.getID())) {
                        try {
                            Annotator epAnnotator = ep.getAnnotator();
                            if (epAnnotator == null) {
                                PluginDescriptor descriptor = ep.getPluginDescriptor();
                                epAnnotator = (Annotator)Class.forName(ep.annotatorClass, true, descriptor == null ? ((Object)((Object)this)).getClass().getClassLoader() : descriptor.getPluginClassLoader()).newInstance();
                                ep.setAnnotator(epAnnotator);
                            }
                            return epAnnotator;
                        }
                        catch (Exception e) {
                            LOG.error(e);
                        }
                    }
                    return null;
                }
            };
            if (smartExtensionPoint == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/Language$2.compute must not return null");
            }
            return smartExtensionPoint;
        }
    };
    private Set<ExternalAnnotator> myInjectedExternalAnnotators;
    private Annotator myLastAnnotator;
    private ExternalAnnotator myLastExternalAnnotator;
    private List<ExternalAnnotator> myCachedExternalAnnotators;
    private final List<CustomFormattingModelBuilder> myCustomFormatters = new ArrayList<CustomFormattingModelBuilder>();
    private DocumentationProvider myDocumentationProvider;
    private FileType myFileType;

    protected Language(@NonNls String id) {
        this(id, "");
    }

    protected Language(@NonNls String ID, String ... mimeTypes) {
        this.myID = ID;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = this.getClass();
        if (ourRegisteredLanguages.containsKey(langClass)) {
            LOG.error("Language '" + langClass.getName() + "' is already registered");
            return;
        }
        ourRegisteredLanguages.put(langClass, this);
    }

    public static Collection<Language> getRegisteredLanguages() {
        return Collections.unmodifiableCollection(ourRegisteredLanguages.values());
    }

    public static <T extends Language> T findInstance(Class<T> klass) {
        return (T)ourRegisteredLanguages.get(klass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(Project project, VirtualFile virtualFile) {
        PlainSyntaxHighlighter plainSyntaxHighlighter = new PlainSyntaxHighlighter();
        if (plainSyntaxHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getSyntaxHighlighter must not return null");
        }
        return plainSyntaxHighlighter;
    }

    @Nullable
    public final FormattingModelBuilder getEffectiveFormattingModelBuilder(PsiElement context) {
        for (CustomFormattingModelBuilder builder : this.myCustomFormatters) {
            if (!builder.isEngagedToFormat(context)) continue;
            return builder;
        }
        return this.getFormattingModelBuilder();
    }

    public final void registerCustomFormattingModelBuilder(@NotNull CustomFormattingModelBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.registerCustomFormattingModelBuilder must not be null");
        }
        this.myCustomFormatters.add(builder);
    }

    public final void unregisterCustomFormattingModelBuilder(@NotNull CustomFormattingModelBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.unregisterCustomFormattingModelBuilder must not be null");
        }
        this.myCustomFormatters.remove(builder);
    }

    @Nullable
    public FormattingModelBuilder getFormattingModelBuilder() {
        return null;
    }

    @Nullable
    public ParserDefinition getParserDefinition() {
        return null;
    }

    @Nullable
    public FoldingBuilder getFoldingBuilder() {
        return null;
    }

    @Nullable
    public PairedBraceMatcher getPairedBraceMatcher() {
        return null;
    }

    @Nullable
    public Commenter getCommenter() {
        return null;
    }

    @NotNull
    public TokenSet getReadableTextContainerElements() {
        TokenSet tokenSet;
        ParserDefinition parserDefinition = this.getParserDefinition();
        if (!(parserDefinition != null ? (tokenSet = parserDefinition.getCommentTokens()) != null : (tokenSet = TokenSet.EMPTY) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getReadableTextContainerElements must not return null");
        }
        return tokenSet;
    }

    @Nullable
    public Annotator getAnnotator() {
        return null;
    }

    public final synchronized void injectAnnotator(@NotNull Annotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.injectAnnotator must not be null");
        }
        this.myAnnotatorsSmartEP.getValue().addExplicitExtension((Object)annotator);
    }

    public final synchronized void injectAnnotator(final @NotNull Annotator annotator, Disposable parentDisposable) {
        if (annotator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.injectAnnotator must not be null");
        }
        this.injectAnnotator(annotator);
        Disposer.register(parentDisposable, new Disposable(){

            public void dispose() {
                Language.this.removeAnnotator(annotator);
            }
        });
    }

    public final synchronized void removeAnnotator(@NotNull Annotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.removeAnnotator must not be null");
        }
        this.myAnnotatorsSmartEP.getValue().removeExplicitExtension((Object)annotator);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final synchronized List<Annotator> getAnnotators() {
        SmartExtensionPoint<AnnotatorEP, Annotator> smartEP = this.myAnnotatorsSmartEP.getValue();
        Annotator annotator = this.getAnnotator();
        if (annotator != this.myLastAnnotator) {
            if (this.myLastAnnotator != null) {
                smartEP.removeExplicitExtension((Object)this.myLastAnnotator);
            }
            if (annotator != null) {
                smartEP.addExplicitExtension((Object)annotator);
            }
            this.myLastAnnotator = annotator;
        }
        List list = smartEP.getExtensions();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getAnnotators must not return null");
        }
        return list;
    }

    @Nullable
    public ExternalAnnotator getExternalAnnotator() {
        return null;
    }

    public final synchronized void injectExternalAnnotator(@NotNull ExternalAnnotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.injectExternalAnnotator must not be null");
        }
        if (this.myInjectedExternalAnnotators == null) {
            this.myInjectedExternalAnnotators = new THashSet();
        }
        this.myInjectedExternalAnnotators.add(annotator);
        this.myCachedExternalAnnotators = null;
    }

    public final synchronized void removeExternalAnnotator(@NotNull ExternalAnnotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.removeExternalAnnotator must not be null");
        }
        if (this.myInjectedExternalAnnotators != null) {
            this.myInjectedExternalAnnotators.remove(annotator);
            this.myCachedExternalAnnotators = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final synchronized List<ExternalAnnotator> getExternalAnnotators() {
        int injectCount;
        List<ExternalAnnotator> list;
        ExternalAnnotator annotator = this.getExternalAnnotator();
        if (annotator == this.myLastExternalAnnotator && this.myCachedExternalAnnotators != null) {
            list = this.myCachedExternalAnnotators;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getExternalAnnotators must not return null");
            return list;
        }
        this.myLastExternalAnnotator = annotator;
        int n = injectCount = this.myInjectedExternalAnnotators == null ? 0 : this.myInjectedExternalAnnotators.size();
        if (annotator == null && injectCount == 0) {
            this.myCachedExternalAnnotators = ExternalAnnotator.EMPTY_LIST;
        } else {
            this.myCachedExternalAnnotators = new ArrayList<ExternalAnnotator>();
            if (annotator != null) {
                this.myCachedExternalAnnotators.add(annotator);
            }
            if (this.myInjectedExternalAnnotators != null) {
                this.myCachedExternalAnnotators.addAll(this.myInjectedExternalAnnotators);
            }
        }
        if ((list = this.myCachedExternalAnnotators) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getExternalAnnotators must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FindUsagesProvider getFindUsagesProvider() {
        EmptyFindUsagesProvider emptyFindUsagesProvider = EMPTY_FIND_USAGES_PROVIDER;
        if (emptyFindUsagesProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getFindUsagesProvider must not return null");
        }
        return emptyFindUsagesProvider;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(PsiFile psiFile) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public RefactoringSupportProvider getRefactoringSupportProvider() {
        DefaultRefactoringSupportProvider defaultRefactoringSupportProvider = new DefaultRefactoringSupportProvider();
        if (defaultRefactoringSupportProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getRefactoringSupportProvider must not return null");
        }
        return defaultRefactoringSupportProvider;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public NamesValidator getNamesValidator() {
        JavaNamesValidator javaNamesValidator = new JavaNamesValidator();
        if (javaNamesValidator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getNamesValidator must not return null");
        }
        return javaNamesValidator;
    }

    @Nullable
    public PsiReferenceAdjuster getReferenceAdjuster() {
        return null;
    }

    @NotNull
    public SurroundDescriptor[] getSurroundDescriptors() {
        if (EMPTY_SURROUND_DESCRIPTORS_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getSurroundDescriptors must not return null");
        }
        return EMPTY_SURROUND_DESCRIPTORS_ARRAY;
    }

    @Nullable
    public ImportOptimizer getImportOptimizer() {
        return null;
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    public String[] getMimeTypes() {
        return this.myMimeTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getID must not return null");
        }
        return string;
    }

    @Nullable
    public FileType getAssociatedFileType() {
        return this.myFileType;
    }

    public void associateFileType(FileType type) {
        this.myFileType = type;
    }

    @Nullable
    public FileViewProvider createViewProvider(VirtualFile file, PsiManager manager, boolean physical) {
        return null;
    }

    @Nullable
    protected DocumentationProvider createDocumentationProvider() {
        return null;
    }

    @Nullable
    public DocumentationProvider getDocumentationProvider() {
        if (this.myDocumentationProvider == null) {
            this.myDocumentationProvider = this.createDocumentationProvider();
        }
        return this.myDocumentationProvider;
    }

    public void setDocumentationProvider(DocumentationProvider documentationProvider) {
        this.myDocumentationProvider = documentationProvider;
    }

    @Nullable
    public LanguageDialect[] getAvailableLanguageDialects() {
        return null;
    }

    @Nullable
    public ParameterInfoHandler[] getParameterInfoHandlers() {
        return null;
    }

    @Nullable
    public LanguageCodeInsightActionHandler getGotoSuperHandler() {
        return null;
    }

    @Nullable
    public LanguageCodeInsightActionHandler getImplementMethodsHandler() {
        return null;
    }

    @Nullable
    public LanguageCodeInsightActionHandler getOverrideMethodsHandler() {
        return null;
    }
}

