/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;

public class CompositeLanguage
extends Language {
    private List<LanguageExtension> myExtensions = new ArrayList<LanguageExtension>();

    protected CompositeLanguage(String id) {
        super(id);
    }

    protected CompositeLanguage(String ID, String ... mimeTypes) {
        super(ID, mimeTypes);
    }

    public void registerLanguageExtension(LanguageExtension extension) {
        if (!this.myExtensions.contains(extension)) {
            this.myExtensions.add(extension);
        }
    }

    public Language[] getLanguageExtensionsForFile(PsiFile psi) {
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageExtension extension : this.myExtensions) {
            if (!extension.isRelevantForFile(psi)) continue;
            extensions.add(extension.getLanguage());
        }
        return extensions.toArray(new Language[extensions.size()]);
    }

    public LanguageExtension[] getLanguageExtensions() {
        return this.myExtensions.toArray(new LanguageExtension[this.myExtensions.size()]);
    }
}

