/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.javaee.model.annotations.JamElement;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.javaee.model.annotations.JamModuleManager;
import com.intellij.javaee.model.annotations.JamRootElement;
import com.intellij.javaee.model.common.CommonModelElement;
import com.intellij.javaee.model.xml.CommonDomModelElement;
import com.intellij.javaee.model.xml.impl.RootBaseImpl;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamCommonUtil {
    @NonNls
    public static final String VALUE_PARAMETER = "value";
    private static Key<CachedValue<Module[]>> MODULE_DEPENDENCIES = Key.create("MODULE_DEPENDENCIES");
    private static Key<CachedValue<Module[]>> MODULE_DEPENDENTS = Key.create("MODULE_DEPENDENTS");

    @Nullable
    public static Object computeMemberValue(PsiElement value) {
        if (value instanceof PsiExpression) {
            try {
                return value.getManager().getConstantEvaluationHelper().computeConstantExpression((PsiExpression)value, false);
            }
            catch (UnsupportedOperationException e) {
            }
        } else if (value instanceof XmlAttributeValue) {
            GenericAttributeValue genericValue = DomManager.getDomManager(value.getProject()).getDomElement((XmlAttribute)value.getParent());
            return genericValue != null ? genericValue.getValue() : ((XmlAttributeValue)value).getValue();
        }
        return null;
    }

    public static boolean isSuperClass(@Nullable PsiClass firstClass, final String superClassQName) {
        return !JamCommonUtil.processSuperClassList(firstClass, new SmartList<PsiClass>(), new Processor<PsiClass>(){

            @Override
            public boolean process(PsiClass superClass) {
                return !Comparing.equal(superClass.getQualifiedName(), superClassQName);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClass> getSuperClassList(@Nullable PsiClass firstClass) {
        SmartList<PsiClass> list = new SmartList<PsiClass>();
        JamCommonUtil.processSuperClassList(firstClass, list, new Processor<PsiClass>(){

            @Override
            public boolean process(PsiClass psiClass) {
                return true;
            }
        });
        SmartList<PsiClass> smartList = list;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getSuperClassList must not return null");
        }
        return smartList;
    }

    public static boolean processSuperClassList(@Nullable PsiClass firstClass, @NotNull Collection<PsiClass> supers, Processor<PsiClass> processor) {
        if (supers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javaee/util/JamCommonUtil.processSuperClassList must not be null");
        }
        for (PsiClass curClass = firstClass; curClass != null && !"java.lang.Object".equals(curClass.getQualifiedName()) && !supers.contains(curClass); curClass = curClass.getSuperClass()) {
            ProgressManager.getInstance().checkCanceled();
            if (!processor.process(curClass)) {
                return false;
            }
            supers.add(curClass);
        }
        return true;
    }

    @Nullable
    public static <T> T getRootElement(PsiFile file, Class<T> domClass, Module module) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        DomManager domManager = DomManager.getDomManager(file.getProject());
        DomFileElement<DomElement> element = domManager.getFileElement((XmlFile)file, DomElement.class);
        if (element == null) {
            return null;
        }
        DomElement root = element.getRootElement();
        if (!ReflectionCache.isAssignable(domClass, root.getClass())) {
            return null;
        }
        if (module != null && root instanceof RootBaseImpl) {
            ((RootBaseImpl)root).registerDomModule(module);
        }
        return (T)root;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends JamRootElement> List<T> getRootElements(PsiElement psiElement, Class<T> rootClass) {
        List list;
        Module module = ModuleUtil.findModuleForPsiElement(psiElement);
        if (module == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getRootElements must not return null");
            return list;
        }
        SmartList result = new SmartList();
        for (Module depModule : JamCommonUtil.getAllDependentModules(module)) {
            ContainerUtil.addIfNotNull(JamModuleManager.getInstance(depModule).getRootElement(rootClass), result);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getRootElements must not return null");
    }

    @Nullable
    public static String getDisplayName(Object element) {
        if (element instanceof CommonModelElement) {
            CommonModelElement javaeeModelElement = (CommonModelElement)element;
            String name = JamCommonUtil.getElementName(javaeeModelElement);
            if (name == null) {
                name = "";
            }
            return JamCommonUtil.getClassName(javaeeModelElement) + " '" + name + "'";
        }
        return null;
    }

    @Nullable
    public static String getElementName(CommonModelElement element) {
        return ElementPresentationManager.getElementName(element);
    }

    public static String getClassName(CommonModelElement element) {
        return ElementPresentationManager.getTypeNameForObject(element);
    }

    @Nullable
    public static Module findModuleForPsiElement(PsiElement element) {
        Module module;
        DomFileElement<CommonDomModelElement> domFileElement;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            VirtualFile virtualFile = PsiUtil.getVirtualFile(element);
            return virtualFile == null ? null : ProjectRootManager.getInstance(element.getProject()).getFileIndex().getModuleForFile(virtualFile);
        }
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile != null) {
            psiFile = originalFile;
        }
        if (psiFile instanceof XmlFile && (domFileElement = DomManager.getDomManager(element.getProject()).getFileElement((XmlFile)psiFile, CommonDomModelElement.class)) != null && (module = domFileElement.getRootElement().getModule()) != null) {
            return module;
        }
        return ModuleUtil.findModuleForPsiElement(psiFile);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] getTargetPsiElements(CommonModelElement element) {
        ArrayList<XmlTag> list = new ArrayList<XmlTag>();
        for (CommonModelElement modelElement : ModelMergerUtil.getFilteredImplementations(element)) {
            if (modelElement instanceof DomElement) {
                DomElement domModelElement = (DomElement)((Object)modelElement);
                if (domModelElement.getXmlTag() == null) continue;
                list.add(domModelElement.getXmlTag());
                continue;
            }
            if (modelElement instanceof JamElement) {
                JamElement annotationModelElement = (JamElement)modelElement;
                if (annotationModelElement instanceof JamMemberElement) {
                    JamMemberElement annotatedElement = (JamMemberElement)annotationModelElement;
                    list.add((XmlTag)annotatedElement.getPsiMember());
                    continue;
                }
                ContainerUtil.addIfNotNull(annotationModelElement.getIdentifyingAnnotation(), list);
                continue;
            }
            ContainerUtil.addIfNotNull(modelElement.getIdentifyingPsiElement(), list);
        }
        PsiElement[] result = list.toArray(PsiElement.EMPTY_ARRAY);
        Arrays.sort(result, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return this.getWeight(o1) - this.getWeight(o2);
            }

            private int getWeight(PsiElement o) {
                if (o instanceof XmlTag) {
                    return 0;
                }
                if (o instanceof PsiMember) {
                    return 1;
                }
                if (o instanceof PsiAnnotation) {
                    return 2;
                }
                return 3;
            }
        });
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getTargetPsiElements must not return null");
        }
        return result;
    }

    public static boolean isInLibrary(CommonModelElement modelElement) {
        if (modelElement == null) {
            return false;
        }
        PsiElement psiElement = modelElement.getIdentifyingPsiElement();
        if (psiElement == null) {
            return false;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance(modelElement.getPsiManager().getProject()).getFileIndex().isInLibraryClasses(virtualFile);
    }

    public static boolean isPlainJavaFile(PsiElement element) {
        return element instanceof PsiJavaFile && element.getLanguage() == StdLanguages.JAVA;
    }

    public static boolean isPlainXmlFile(PsiElement element) {
        return element instanceof XmlFile && element.getLanguage() == StdLanguages.XML;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Module[] getAllModuleDependencies(final Module module) {
        CachedValue<Module[]> value = module.getUserData(MODULE_DEPENDENCIES);
        if (value == null) {
            value = PsiManager.getInstance(module.getProject()).getCachedValuesManager().createCachedValue(new CachedValueProvider<Module[]>(){

                @Override
                public CachedValueProvider.Result<Module[]> compute() {
                    Set<Module> result = JamCommonUtil.addModuleDependencies(module, (Set<Module>)new THashSet(), false);
                    return new CachedValueProvider.Result<Module[]>(result.toArray(new Module[result.size()]), ProjectRootManager.getInstance(module.getProject()));
                }
            }, false);
            module.putUserData(MODULE_DEPENDENCIES, value);
        }
        Module[] moduleArray = value.getValue();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getAllModuleDependencies must not return null");
        }
        return moduleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Module[] getAllDependentModules(final Module module) {
        CachedValue<Module[]> value = module.getUserData(MODULE_DEPENDENTS);
        if (value == null) {
            value = PsiManager.getInstance(module.getProject()).getCachedValuesManager().createCachedValue(new CachedValueProvider<Module[]>(){

                @Override
                public CachedValueProvider.Result<Module[]> compute() {
                    Module[] modules = ModuleManager.getInstance(module.getProject()).getModules();
                    Set<Module> result = JamCommonUtil.addModuleDependents(module, (Set<Module>)new THashSet(), modules);
                    return new CachedValueProvider.Result<Module[]>(result.toArray(new Module[result.size()]), ProjectRootManager.getInstance(module.getProject()));
                }
            }, false);
            module.putUserData(MODULE_DEPENDENTS, value);
        }
        Module[] moduleArray = value.getValue();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/util/JamCommonUtil.getAllDependentModules must not return null");
        }
        return moduleArray;
    }

    public static Set<Module> addModuleDependencies(Module module, Set<Module> result, boolean exported) {
        OrderEntry[] orderEntries;
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance(module).getOrderEntries()) {
            Module exportedModule;
            if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || exported && !((ModuleOrderEntry)orderEntry).isExported() || !result.add(exportedModule = ((ModuleOrderEntry)orderEntry).getModule())) continue;
            JamCommonUtil.addModuleDependencies(exportedModule, result, true);
        }
        return result;
    }

    public static Set<Module> addModuleDependents(Module module, Set<Module> result, Module[] modules) {
        if (!result.add(module)) {
            return result;
        }
        for (Module allModule : modules) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance(allModule).getOrderEntries()) {
                Module exportedModule;
                if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || (exportedModule = ((ModuleOrderEntry)orderEntry).getModule()) != module || !result.add(allModule) || !((ModuleOrderEntry)orderEntry).isExported()) continue;
                JamCommonUtil.addModuleDependents(allModule, result, modules);
            }
        }
        return result;
    }
}

