/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AnnotationManipulator<T> {
    public static final AnnotationManipulator<PsiModifierListOwner> PSI_MANIPULATOR = new AnnotationManipulator<PsiModifierListOwner>(){

        @Override
        public void addAnnotation(PsiModifierListOwner owner, String text, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            PsiAnnotation annotation = owner.getManager().getElementFactory().createAnnotationFromText(text, null);
            PsiModifierList list = owner.getModifierList();
            if (list != null) {
                list.addBefore(annotation, null);
            }
        }

        @Override
        public void removeAnnotation(PsiModifierListOwner owner, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            existingAnnotation.delete();
        }

        @Override
        @Nullable
        public PsiAnnotation findAnnotation(PsiModifierListOwner owner, String annotationName) {
            PsiModifierList list = owner.getModifierList();
            return list == null ? null : list.findAnnotation(annotationName);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public PsiElement getElement(PsiModifierListOwner owner) {
            PsiModifierListOwner psiModifierListOwner = owner;
            if (psiModifierListOwner == null) {
                throw new IllegalStateException("@NotNull method com/intellij/javaee/util/AnnotationManipulator$1.getElement must not return null");
            }
            return psiModifierListOwner;
        }
    };
    public static final AnnotationManipulator<JamMemberElement> JAM_MANIPULATOR = new AnnotationManipulator<JamMemberElement>(){

        @Override
        public void addAnnotation(JamMemberElement owner, String text, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            PsiAnnotation annotation = this.getElement(owner).getManager().getElementFactory().createAnnotationFromText(text, null);
            owner.addAnnotation(annotation);
        }

        @Override
        public void removeAnnotation(JamMemberElement owner, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
            owner.removeAnnotation(existingAnnotation.getQualifiedName());
        }

        @Override
        public PsiAnnotation findAnnotation(JamMemberElement owner, String annotationName) {
            return PSI_MANIPULATOR.findAnnotation(owner.getPsiMember(), annotationName);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public PsiElement getElement(JamMemberElement owner) {
            Object t = owner.getPsiMember();
            if (t == null) {
                throw new IllegalStateException("@NotNull method com/intellij/javaee/util/AnnotationManipulator$2.getElement must not return null");
            }
            return t;
        }
    };

    public void addAnnotation(T var1, String var2, PsiAnnotation var3) throws IncorrectOperationException;

    public void removeAnnotation(T var1, PsiAnnotation var2) throws IncorrectOperationException;

    @Nullable
    public PsiAnnotation findAnnotation(T var1, String var2);

    @NotNull
    public PsiElement getElement(T var1);
}

