/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.impl;

import com.intellij.javaee.model.xml.CommonDomModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.Nullable;

public abstract class BaseImpl
implements CommonDomModelElement {
    public PsiManager getPsiManager() {
        return PsiManager.getInstance(this.getManager().getProject());
    }

    public PsiElement getIdentifyingPsiElement() {
        return this.getXmlTag();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.getRoot().getFile();
    }

    @Nullable
    protected final PsiClass findPsiClass(String className) {
        if (className == null) {
            return null;
        }
        Module module = this.getModule();
        return this.getPsiManager().findClass(className, module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module) : GlobalSearchScope.projectScope(this.getManager().getProject()));
    }

    @Nullable
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        if (this.getManager().isMockElement(this)) {
            return this.getRoot().getUserData(DomManager.MOCK_ELEMENT_MODULE);
        }
        Object root = this.getRoot().getRootElement();
        if (this == root) {
            PsiElement element = this.getIdentifyingPsiElement();
            return element == null ? null : ModuleUtil.findModuleForPsiElement(element);
        }
        return root.getModule();
    }
}

