/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.common;

import com.intellij.javaee.model.annotations.AnnotationElement;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.javaee.model.common.CommonModelElement;
import com.intellij.javaee.model.common.TakeFromXml;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.Function;
import com.intellij.util.ReflectionCache;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.PrimaryKey;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonModelMerger {
    private final Map<Class, Function<?, ?>> myAnnoFactories = new THashMap();
    private ModelMerger myMerger;

    protected CommonModelMerger(Project project) {
        this.myMerger = DomManager.getDomManager(project).createModelMerger();
        this.myMerger.addMergingStrategy(Object.class, new JavaeeMergingStrategy());
        this.myMerger.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return DomReflectionUtil.findAnnotationDFS(method, PrimaryKey.class) != null;
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(implementations.get(0), args);
            }
        });
        this.myMerger.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return DomReflectionUtil.findAnnotationDFS(method, TakeFromXml.class) != null;
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                DomElement domElement = ModelMergerUtil.getImplementation(DomElement.class, implementations);
                return method.invoke(domElement != null ? domElement : implementations.get(0), args);
            }
        });
    }

    private <T> Function<T, ?> getRegisteredAnnotationImplementation(Class<? extends T> aClass) {
        return this.myAnnoFactories.get(aClass);
    }

    protected <T> void registeredAnnoElementFactory(Class<T> aClass, Function<T, ? extends T> factory) {
        this.myAnnoFactories.put(aClass, factory);
    }

    protected boolean shouldBeMerged(Object domElement) {
        return true;
    }

    public final <T extends CommonModelElement> T mergeModels(Class<T> targetClass, Collection<T> implementations) {
        for (CommonModelElement implementation : implementations) {
            if (this.shouldBeMerged(implementation)) continue;
            return (T)implementation;
        }
        return (T)((CommonModelElement)this.getMerger().mergeModels(targetClass, implementations));
    }

    public final ModelMerger getMerger() {
        return this.myMerger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AnnoFactoryBase<T, V extends JamMemberElement>
    implements Function<T, V> {
        private final Class<V> myClass;

        protected AnnoFactoryBase(Class<V> aClass) {
            this.myClass = aClass;
        }

        @Nullable
        protected abstract PsiClass getPsiClass(T var1);

        @NotNull
        protected abstract V create(PsiClass var1, T var2);

        @Override
        @Nullable
        public V fun(T t) {
            PsiClass aClass = this.getPsiClass(t);
            if (aClass != null) {
                List<V> list = AnnotationModelUtil.getAnnotatedElements(aClass, this.myClass);
                return (V)(list.size() > 0 ? (JamMemberElement)list.get(0) : this.create(aClass, t));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaeeMergingStrategy
    extends ModelMerger.MergingStrategy<Object> {
        protected JavaeeMergingStrategy() {
        }

        @Nullable
        private <T> Function<T, ?> getAnnotationImplementation(Class<? extends T> aClass) {
            Function<?, ?> candidate = CommonModelMerger.this.getRegisteredAnnotationImplementation(aClass);
            if (candidate != null) {
                return candidate;
            }
            for (Class<?> anInterface : aClass.getInterfaces()) {
                candidate = this.getAnnotationImplementation(anInterface);
                if (candidate == null) continue;
                return candidate;
            }
            return null;
        }

        @Override
        public Object mergeChildren(Class<Object> type, List<Object> implementations) {
            Function<Object, ?> annoImplFactory;
            if (!ReflectionCache.isAssignable(CommonModelElement.class, type) && !ReflectionCache.isAssignable(GenericValue.class, type)) {
                return implementations.get(0);
            }
            boolean hasAnnotationElement = false;
            for (int i = 0; i < implementations.size(); ++i) {
                Object implementation = implementations.get(i);
                if (implementation instanceof AnnotationElement) {
                    int lastIndex = implementations.size() - 1;
                    if (i != lastIndex) {
                        assert (!hasAnnotationElement) : "more than one annotation element: " + implementations;
                        AnnotationElement annotationElement = (AnnotationElement)implementation;
                        implementations.remove(i);
                        implementations.add(annotationElement);
                        --i;
                    }
                    hasAnnotationElement = true;
                    continue;
                }
                if (implementation instanceof DomElement || !(implementation instanceof MergedObject)) continue;
                MergedObject mergedObject = (MergedObject)implementation;
                implementations.remove(i--);
                int cnt = 1;
                for (Object o : mergedObject.getImplementations()) {
                    implementations.add(i + cnt++, o);
                }
            }
            if (!hasAnnotationElement && (annoImplFactory = this.getAnnotationImplementation(type)) != null) {
                Object domElement = implementations.size() == 1 ? implementations.get(0) : CommonModelMerger.this.myMerger.mergeModels(type, implementations);
                for (Object implementation : implementations) {
                    if (CommonModelMerger.this.shouldBeMerged(implementation)) continue;
                    return domElement;
                }
                Object annotationElement = annoImplFactory.fun(domElement);
                if (annotationElement == null) {
                    return domElement;
                }
                return CommonModelMerger.this.myMerger.mergeModels(type, domElement, annotationElement);
            }
            return CommonModelMerger.this.myMerger.mergeModels(type, implementations);
        }
    }
}

