/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaeeInterceptorSupport<T extends JamMemberElement>
implements ModificationTracker {
    private final Module myModule;
    private final PsiManager myPsiManager;
    private final String myAnnotationName;
    private final Class<T> myInterceptorClass;
    private final String[] myMethodAnnotations;
    private Set<PsiClass> myInterceptorClasses = new HashSet<PsiClass>();
    private List<T> myInterceptors;
    private long myModificationCount = -1L;

    protected abstract T createInterceptor(PsiClass var1, PsiAnnotation var2, PsiAnnotationMemberValue var3);

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    protected JavaeeInterceptorSupport(Module module, Class<T> interceptorClass, String annotationName, String ... methodAnnotations) {
        this.myModule = module;
        this.myAnnotationName = annotationName;
        this.myInterceptorClass = interceptorClass;
        this.myMethodAnnotations = methodAnnotations;
        this.myPsiManager = PsiManager.getInstance(module.getProject());
    }

    public void reset() {
        this.myInterceptorClasses.clear();
        this.myInterceptors = null;
    }

    public List<T> getInterceptors() {
        if (this.myInterceptors == null || this.myModificationCount != this.myPsiManager.getModificationTracker().getOutOfCodeBlockModificationCount()) {
            this.myModificationCount = this.myPsiManager.getModificationTracker().getOutOfCodeBlockModificationCount();
            final HashMap map = new HashMap();
            AnnotationModelUtil.findAnnotatedPsiMembers(this.myAnnotationName, this.myPsiManager, this.myModule, new Processor<PsiMember>(){

                @Override
                public boolean process(PsiMember psiMember) {
                    PsiAnnotation psiAnnotation = psiMember.getModifierList().findAnnotation(JavaeeInterceptorSupport.this.myAnnotationName);
                    for (AnnotationGenericValue<PsiClass> value : AnnotationModelUtil.getPsiClassArrayValue(psiAnnotation, "value")) {
                        map.put(value.getValue(), value);
                    }
                    return true;
                }
            });
            ArrayList<T> interceptors = new ArrayList<T>();
            Iterator<PsiClass> it = this.myInterceptorClasses.iterator();
            while (it.hasNext()) {
                PsiClass aClass = it.next();
                List<JamMemberElement> list = AnnotationModelUtil.getAnnotatedElements(aClass, this.myInterceptorClass);
                if (!map.containsKey(aClass)) {
                    for (JamMemberElement t : list) {
                        t.invalidate();
                    }
                    continue;
                }
                boolean hasValid = false;
                for (JamMemberElement t : list) {
                    if (!t.isValid()) continue;
                    interceptors.add(t);
                    hasValid = true;
                }
                if (hasValid) continue;
                it.remove();
            }
            for (Map.Entry entry : map.entrySet()) {
                if (this.myInterceptorClasses.contains(entry.getKey())) continue;
                AnnotationGenericValue value = (AnnotationGenericValue)entry.getValue();
                interceptors.add(this.createInterceptor((PsiClass)entry.getKey(), value.getIdentifyingAnnotation(), value.getDefiningElement()));
            }
            this.myInterceptorClasses = new HashSet(map.keySet());
            this.myInterceptors = interceptors;
        }
        return this.myInterceptors;
    }

    public List<T> getInterceptors(Collection<? extends GenericValue<PsiClass>> psiClasses) {
        if (psiClasses.size() == 0) {
            return Collections.emptyList();
        }
        this.getInterceptors();
        ArrayList<T> result = new ArrayList<T>();
        for (GenericValue<PsiClass> genericValue : psiClasses) {
            PsiClass psiClass = genericValue.getValue();
            if (psiClass == null) continue;
            result.addAll(AnnotationModelUtil.getAnnotatedElements(psiClass, this.myInterceptorClass));
        }
        return result;
    }
}

