/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.BaseJamElement;
import com.intellij.javaee.model.annotations.BaseJamMemberElement;
import com.intellij.javaee.model.annotations.JamManager;
import com.intellij.javaee.model.annotations.JamModelSupport;
import com.intellij.javaee.model.annotations.JamRootElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJamRootElement
extends BaseJamElement
implements JamRootElement {
    private final Module myModule;
    private final JamModelSupport mySupport;
    private final Map<String, Pair<Class, PairFunction>> myFactories;

    public BaseJamRootElement(@NotNull Module module, @NotNull JamModelSupport support) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javaee/model/annotations/BaseJamRootElement.<init> must not be null");
        }
        if (support == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javaee/model/annotations/BaseJamRootElement.<init> must not be null");
        }
        this.myFactories = new THashMap();
        this.myModule = module;
        this.mySupport = support;
        JamManager.getInstance(this.myModule.getProject()).addModelSupport(support);
    }

    @Override
    public void dispose() {
        if (this.myModule.getProject().isDisposed()) {
            return;
        }
        JamManager.getInstance(this.myModule.getProject()).removeModelSupport(this.mySupport);
        this.invalidate();
    }

    @Override
    public PsiManager getPsiManager() {
        return PsiManager.getInstance(this.myModule.getProject());
    }

    @Override
    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return null;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    protected final <T extends BaseJamMemberElement<PsiClass>> void registerJamElementFactory(@NonNls String anno, Class<T> aClass, PairFunction<PsiClass, PsiAnnotation, T> function) {
        this.myFactories.put(anno, new Pair<Class<T>, PairFunction<PsiClass, PsiAnnotation, T>>(aClass, function));
    }

    public boolean updatePsiClass(PsiClass psiClass) {
        boolean hasChanges = false;
        if (!this.isInitialized()) {
            return hasChanges;
        }
        for (String anno : this.myFactories.keySet()) {
            PsiAnnotation annotation = BaseJamRootElement.findAnnotation(psiClass, anno);
            if (annotation == null) continue;
            hasChanges = true;
            ((PairFunction)this.myFactories.get((Object)anno).second).fun(psiClass, annotation);
        }
        return hasChanges;
    }

    public final void initializePsiClasses() {
        for (final String anno : this.myFactories.keySet()) {
            AnnotationModelUtil.findAnnotatedPsiMembers(anno, this.getPsiManager(), this.getModule(), new Processor<PsiMember>(){

                @Override
                public boolean process(PsiMember t) {
                    if (t instanceof PsiClass) {
                        ((PairFunction)((Pair)((BaseJamRootElement)BaseJamRootElement.this).myFactories.get((Object)anno)).second).fun(t, BaseJamElement.findAnnotation(t, anno));
                    }
                    return true;
                }
            });
        }
    }

    protected final <T extends BaseJamMemberElement<PsiClass>> List<T> getPsiClassChildren(@NonNls String anno) {
        if (!this.checkInitialized() || !this.isValid()) {
            return Collections.emptyList();
        }
        return this.getPsiClassChildren(anno, new ArrayList());
    }

    protected final <T extends BaseJamMemberElement<PsiClass>> List<T> getPsiClassChildren(@NonNls String anno, List<T> result) {
        if (!this.checkInitialized() || !this.isValid()) {
            return result;
        }
        return AnnotationModelUtil.findAnnotatedElements(anno, result, (Class)this.myFactories.get((Object)anno).first, this.getPsiManager(), this.getModule());
    }

    @Override
    protected void doInitialize() {
        this.initializePsiClasses();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateImpl();
    }

    protected void invalidateImpl() {
        for (String anno : this.myFactories.keySet()) {
            for (BaseJamMemberElement element : this.getPsiClassChildren(anno)) {
                element.invalidate();
            }
        }
    }
}

