/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.BaseJamElement;
import com.intellij.javaee.model.annotations.BaseJamRootElement;
import com.intellij.javaee.model.annotations.JamElement;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.javaee.model.annotations.JamRootElement;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionCache;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJamMemberElement<T extends PsiMember>
extends BaseJamElement
implements JamMemberElement<T> {
    private JamElement myParent;
    private BaseJamMemberElement myNextAnnotatedElement;
    private T myPsiMember;
    private final PsiAnnotation myIdentifyingAnnotation;
    private final boolean myDoBind;

    protected BaseJamMemberElement(JamElement parent, T psiMember, PsiAnnotation identifyingAnnotation) {
        this(parent, psiMember, identifyingAnnotation, true);
    }

    protected BaseJamMemberElement(JamElement parent, T psiMember, PsiAnnotation identifyingAnnotation, boolean doBind) {
        this.myParent = parent;
        this.myIdentifyingAnnotation = identifyingAnnotation;
        this.myDoBind = doBind;
        this.setPsiMember(psiMember);
    }

    protected final void setParent(BaseJamElement parent) {
        assert (this.myParent == null) : "parent is already initialized";
        this.myParent = parent;
    }

    @Override
    public final <V extends JamElement> V getParent() {
        return (V)this.myParent;
    }

    @Override
    public final <V extends JamRootElement> V getRoot() {
        return (V)this.getParentOfType(JamRootElement.class, false);
    }

    @Override
    @Nullable
    public final <V extends JamElement> V getParentOfType(Class<V> parentClass, boolean strict) {
        JamElement e;
        JamElement jamElement = e = strict ? this.myParent : this;
        while (e != null) {
            if (ReflectionCache.isAssignable(parentClass, e.getClass())) {
                return (V)e;
            }
            e = e instanceof BaseJamMemberElement ? ((BaseJamMemberElement)e).getParent() : null;
        }
        return null;
    }

    protected static void bindToPsi(PsiElement psiElement, BaseJamMemberElement element) {
        BaseJamMemberElement other = (BaseJamMemberElement)psiElement.getUserData(CACHED_ELEMENT_KEY);
        element.myNextAnnotatedElement = null;
        if (other == null) {
            psiElement.putUserData(CACHED_ELEMENT_KEY, element);
        } else {
            BaseJamMemberElement last = null;
            BaseJamMemberElement it = other;
            while (it != null) {
                if (Comparing.equal(it, element)) {
                    return;
                }
                last = it;
                it = it.myNextAnnotatedElement;
            }
            last.myNextAnnotatedElement = element;
        }
    }

    protected static void unbindFromPsi(PsiElement psiElement, BaseJamMemberElement element) {
        BaseJamMemberElement other = (BaseJamMemberElement)psiElement.getUserData(CACHED_ELEMENT_KEY);
        if (other == null) {
            return;
        }
        if (other == element) {
            psiElement.putUserData(CACHED_ELEMENT_KEY, element.myNextAnnotatedElement);
        } else {
            BaseJamMemberElement it = other;
            while (it != null) {
                if (it == element) {
                    other.myNextAnnotatedElement = it.myNextAnnotatedElement;
                    return;
                }
                other = it;
                it = it.myNextAnnotatedElement;
            }
        }
    }

    public BaseJamMemberElement<? extends PsiMember> getNextElement() {
        return this.myNextAnnotatedElement;
    }

    protected void dropCachedObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiAnnotation addAnnotation(PsiAnnotation annotation) throws IncorrectOperationException {
        boolean oldHandleEvents = this.getJamManager().setHandleEvents(false);
        try {
            T member = this.getPsiMember();
            assert (member != null);
            PsiModifierList modifierList = member.getModifierList();
            assert (modifierList != null);
            PsiAnnotation[] psiAnnotations = modifierList.getAnnotations();
            PsiAnnotation annoAnchor = psiAnnotations.length > 0 ? psiAnnotations[psiAnnotations.length - 1] : null;
            PsiAnnotation existingAnno = modifierList.findAnnotation(annotation.getQualifiedName());
            PsiElement newAnnotation = existingAnno != null ? existingAnno.replace(annotation) : modifierList.addAfter(annotation, annoAnchor);
            PsiAnnotation result = (PsiAnnotation)newAnnotation.getManager().getCodeStyleManager().shortenClassReferences(newAnnotation);
            this.dropCachedObjects();
            PsiAnnotation psiAnnotation = result;
            return psiAnnotation;
        }
        finally {
            this.getJamManager().setHandleEvents(oldHandleEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAnnotation(String qualifiedName) throws IncorrectOperationException {
        boolean oldHandleEvents = this.getJamManager().setHandleEvents(false);
        try {
            T member = this.getPsiMember();
            assert (member != null);
            PsiModifierList modifierList = member.getModifierList();
            assert (modifierList != null);
            PsiAnnotation annotation = modifierList.findAnnotation(qualifiedName);
            if (annotation != null) {
                annotation.delete();
                this.dropCachedObjects();
            }
        }
        finally {
            this.getJamManager().setHandleEvents(oldHandleEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnnotationParameter(PsiAnnotation annotation, String paramName, String value) throws IncorrectOperationException {
        boolean oldHandleEvents = this.getJamManager().setHandleEvents(false);
        try {
            assert (PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class) == this.getPsiMember()) : "invalid annotation psi member";
            AnnotationTextUtil.setAnnotationParameter(annotation, paramName, value);
            this.dropCachedObjects();
        }
        finally {
            this.getJamManager().setHandleEvents(oldHandleEvents);
        }
    }

    @Override
    public PsiElement getIdentifyingPsiElement() {
        PsiElement element = super.getIdentifyingPsiElement();
        return element != null ? element : this.getPsiMember();
    }

    @Override
    @Nullable
    public final T getPsiMember() {
        return this.myPsiMember;
    }

    protected final void setPsiMember(T psiMember) {
        assert (this.myPsiMember == null) : "psiMember is already initialized";
        this.myPsiMember = psiMember;
        if (this.myDoBind && this.myPsiMember != null) {
            BaseJamMemberElement.bindToPsi(this.myPsiMember, this);
        }
    }

    @Override
    public Module getModule() {
        Module module;
        BaseJamRootElement root = this.getParentOfType(BaseJamRootElement.class, false);
        if (root != null) {
            module = root.getModule();
        } else if (this.myIdentifyingAnnotation != null) {
            module = ModuleUtil.findModuleForPsiElement(this.myIdentifyingAnnotation);
        } else if (this.myPsiMember != null) {
            module = ModuleUtil.findModuleForPsiElement(this.myPsiMember);
        } else {
            assert (false) : "module not found";
            module = null;
        }
        return module;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.myDoBind && this.myPsiMember != null) {
            BaseJamMemberElement.unbindFromPsi(this.myPsiMember, this);
        }
    }

    @Override
    public boolean isValid() {
        return !(!super.isValid() || this.myPsiMember != null && !this.myPsiMember.isValid() || this.myIdentifyingAnnotation != null && !this.myIdentifyingAnnotation.isValid());
    }

    @Override
    @Nullable
    public final PsiAnnotation getIdentifyingAnnotation() {
        return this.myIdentifyingAnnotation;
    }

    @Nullable
    protected PsiAnnotation findAnnotation(String annoName) {
        return this.myPsiMember == null || !this.myPsiMember.isValid() ? null : this.myPsiMember.getModifierList().findAnnotation(annoName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseJamMemberElement that = (BaseJamMemberElement)o;
        if (this.isValid() != that.isValid()) {
            return false;
        }
        if (this.myIdentifyingAnnotation != null ? !this.myIdentifyingAnnotation.equals(that.myIdentifyingAnnotation) : that.myIdentifyingAnnotation != null) {
            return false;
        }
        Object root = this.getRoot();
        Object thatRoot = that.getRoot();
        if (root != null ? !root.equals(thatRoot) : thatRoot != null) {
            return false;
        }
        return !(this.myPsiMember != null ? !this.myPsiMember.equals(that.myPsiMember) : that.myPsiMember != null);
    }

    public int hashCode() {
        Object root = this.getRoot();
        int result = root != null ? root.hashCode() : 0;
        result = 31 * result + (this.myPsiMember != null ? this.myPsiMember.hashCode() : 0);
        result = 31 * result + (this.myIdentifyingAnnotation != null ? this.myIdentifyingAnnotation.hashCode() : 0);
        return result;
    }

    protected <T extends JamMemberElement> List<T> getAnnotatedMembersList(Class<T> clazz, PsiClass psiClass, boolean checkClass, boolean checkMethods, boolean checkFields) {
        if (!this.checkInitialized()) {
            return Collections.emptyList();
        }
        return AnnotationModelUtil.getAnnotatedMembersList(psiClass, clazz, checkClass, checkMethods, checkFields, true);
    }
}

