/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.BaseJamMemberElement;
import com.intellij.javaee.model.annotations.JamElement;
import com.intellij.javaee.model.annotations.JamManagerEx;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJamElement
implements JamElement {
    protected static final Key<BaseJamMemberElement> CACHED_ELEMENT_KEY = Key.create("Cached annotation element");
    private boolean myInitialized;
    private boolean myInvalidated;

    @Nullable
    protected static PsiAnnotation findAnnotation(PsiMember member, String className) {
        PsiModifierList list = member.getModifierList();
        return list == null ? null : list.findAnnotation(className);
    }

    protected static JamMemberElement getFirstAnnotatedElement(PsiElement element) {
        return element.getUserData(CACHED_ELEMENT_KEY);
    }

    protected abstract void doInitialize();

    @Nullable
    public abstract PsiAnnotation getIdentifyingAnnotation();

    @Nullable
    public PsiAnnotationMemberValue getDefiningElement() {
        return null;
    }

    protected void doDeinitialize() {
    }

    public Module getModule() {
        PsiElement psiElement = this.getIdentifyingPsiElement();
        return psiElement != null ? ModuleUtil.findModuleForPsiElement(psiElement) : null;
    }

    public PsiManager getPsiManager() {
        return this.getIdentifyingPsiElement().getManager();
    }

    public PsiElement getIdentifyingPsiElement() {
        PsiAnnotation psiAnnotation = this.getIdentifyingAnnotation();
        return psiAnnotation == null ? this.getXmlTag() : psiAnnotation;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element = this.getIdentifyingPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    protected final synchronized boolean isInitialized() {
        return this.myInitialized;
    }

    protected final synchronized boolean checkInitialized() {
        if (this.myInitialized || this.myInvalidated) {
            return this.myInitialized;
        }
        this.doInitialize();
        this.myInitialized = true;
        return this.myInitialized;
    }

    protected final synchronized void deinitialize() {
        if (!this.myInitialized || this.myInvalidated) {
            return;
        }
        this.myInitialized = false;
        this.doDeinitialize();
    }

    public void invalidate() {
        this.myInvalidated = true;
    }

    public boolean isValid() {
        PsiElement element = this.getIdentifyingPsiElement();
        return !this.myInvalidated && (element == null || element.isValid());
    }

    public XmlTag getXmlTag() {
        return null;
    }

    public JamManagerEx getJamManager() {
        return JamManagerEx.getInstance(this.getPsiManager().getProject());
    }
}

