/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.JamElement;
import com.intellij.javaee.model.annotations.JamManager;
import com.intellij.javaee.model.annotations.JamMemberElement;
import com.intellij.javaee.model.annotations.JamRootElement;
import com.intellij.javaee.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.converters.QuotedValueConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationModelUtil {
    private AnnotationModelUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<JamMemberElement> getAnnotatedElements(PsiMember psiMember) {
        ArrayList<JamMemberElement> result = new ArrayList<JamMemberElement>();
        for (JamMemberElement<PsiMember> element = AnnotationModelUtil.getFirstAnnotatedElement(psiMember); element != null; element = element.getNextElement()) {
            if (!AnnotationModelUtil.checkIsValid(element)) continue;
            result.add(element);
        }
        ArrayList<JamMemberElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotatedElements must not return null");
        }
        return arrayList;
    }

    private static boolean checkIsValid(JamMemberElement element) {
        Object root = element.getRoot();
        if (!element.isValid() || root != null && !root.isValid()) {
            element.invalidate();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> getAnnotatedElements(@NotNull PsiMember psiElement, Class<T> elementClass) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotatedElements must not be null");
        }
        SmartList<JamMemberElement<PsiMember>> list = new SmartList<JamMemberElement<PsiMember>>();
        for (JamMemberElement<PsiMember> element = AnnotationModelUtil.getFirstAnnotatedElement(psiElement); element != null; element = element.getNextElement()) {
            if (!AnnotationModelUtil.checkIsValid(element) || !ReflectionCache.isAssignable(elementClass, element.getClass())) continue;
            list.add(element);
        }
        SmartList<JamMemberElement<PsiMember>> smartList = list;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotatedElements must not return null");
        }
        return smartList;
    }

    @Nullable
    public static <T> T getAnnotatedElement(@NotNull PsiMember psiElement, Class<T> elementClass, JamRootElement rootElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotatedElement must not be null");
        }
        for (JamMemberElement<PsiMember> element = AnnotationModelUtil.getFirstAnnotatedElement(psiElement); element != null; element = element.getNextElement()) {
            if (!AnnotationModelUtil.checkIsValid(element) || !ReflectionCache.isAssignable(elementClass, element.getClass()) || element.getRoot() != rootElement) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAnnotationValue(PsiAnnotation annotation, String parameterName, String childAnnotationName) {
        PsiAnnotation childAnnotation;
        PsiAnnotationMemberValue annotationMemberValue;
        if (annotation != null && (annotationMemberValue = annotation.findAttributeValue(parameterName)) instanceof PsiAnnotation && childAnnotationName.equals((childAnnotation = (PsiAnnotation)annotationMemberValue).getQualifiedName())) {
            return childAnnotation;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiAnnotation> getAnnotationsValue(PsiAnnotation annotation, String parameterName, String childAnnotationName) {
        List<PsiAnnotation> list;
        if (annotation != null) {
            PsiAnnotation childAnnotation;
            PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue(parameterName);
            if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue psiArrayInitializerMemberValue = (PsiArrayInitializerMemberValue)annotationMemberValue;
                ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
                for (PsiAnnotationMemberValue value : psiArrayInitializerMemberValue.getInitializers()) {
                    PsiAnnotation childAnnotation2;
                    if (!(value instanceof PsiAnnotation) || !childAnnotationName.equals((childAnnotation2 = (PsiAnnotation)value).getQualifiedName())) continue;
                    result.add(childAnnotation2);
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotationsValue must not return null");
                return list;
            }
            if (annotationMemberValue instanceof PsiAnnotation && childAnnotationName.equals((childAnnotation = (PsiAnnotation)annotationMemberValue).getQualifiedName())) {
                list = Collections.singletonList(childAnnotation);
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotationsValue must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getAnnotationsValue must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<AnnotationGenericValue<String>> getStringArrayValue(PsiAnnotation annotation, String attributeName) {
        List<AnnotationGenericValue<String>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, Function.ID);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getStringArrayValue must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends Enum> List<AnnotationGenericValue<T>> getEnumArrayValue(PsiAnnotation annotation, String attributeName, Class<T> clazz) {
        List<AnnotationGenericValue<T>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, clazz, Function.ID);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getEnumArrayValue must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Function<String, T> function) {
        List<AnnotationGenericValue<T>> list = AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, String.class, function);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getObjectArrayValue must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, V> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Class<V> clazz, Function<V, T> mapper) {
        List<AnnotationGenericValue<T>> list;
        if (annotation != null) {
            V obj;
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            if (memberValue instanceof PsiArrayInitializerMemberValue) {
                ArrayList<AnnotationGenericValue<T>> result = new ArrayList<AnnotationGenericValue<T>>();
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)memberValue;
                for (PsiAnnotationMemberValue value : arrayValue.getInitializers()) {
                    V obj2 = AnnotationModelUtil.getObjectValue(value, clazz);
                    if (obj2 == null) continue;
                    result.add(AnnotationGenericValue.getInstance(mapper.fun(obj2), annotation, value));
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getObjectArrayValue must not return null");
                return list;
            }
            if (memberValue != null && (obj = AnnotationModelUtil.getObjectValue(memberValue, clazz)) != null) {
                list = Collections.singletonList(AnnotationGenericValue.getInstance(mapper.fun(obj), annotation, memberValue));
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getObjectArrayValue must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getObjectArrayValue must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static AnnotationGenericValue<Boolean> getBooleanValue(PsiAnnotation annotation) {
        AnnotationGenericValue<Boolean> annotationGenericValue = AnnotationGenericValue.getInstance(annotation != null ? Boolean.TRUE : Boolean.FALSE, annotation, null);
        if (annotationGenericValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getBooleanValue must not return null");
        }
        return annotationGenericValue;
    }

    @NotNull
    public static <T extends Enum> AnnotationGenericValue<T> getEnumValue(PsiAnnotation annotation, String attributeName, Class<T> clazz) {
        AnnotationGenericValue<T> annotationGenericValue;
        PsiAnnotationMemberValue memberValue;
        T value;
        if (!(annotation != null && (value = AnnotationModelUtil.getEnumValue(memberValue = annotation.findAttributeValue(attributeName), clazz)) != null ? (annotationGenericValue = AnnotationGenericValue.getInstance(value, annotation, memberValue)) != null : (annotationGenericValue = AnnotationGenericValue.NULL) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getEnumValue must not return null");
        }
        return annotationGenericValue;
    }

    @Nullable
    public static <T extends Enum> T getEnumValue(PsiAnnotationMemberValue memberValue, Class<T> clazz) {
        PsiReferenceExpression psiReferenceExpression;
        PsiElement psiElement;
        assert (ReflectionCache.isAssignable(Enum.class, clazz));
        if (memberValue instanceof PsiReferenceExpression && (psiElement = (psiReferenceExpression = (PsiReferenceExpression)memberValue).resolve()) instanceof PsiField) {
            PsiField psiField = (PsiField)psiElement;
            return Enum.valueOf(clazz, psiField.getName());
        }
        return null;
    }

    @NotNull
    public static <T> AnnotationGenericValue<T> getLazyObjectValue(PsiAnnotation annotation, @NonNls String attributeName, Function<String, T> converter) {
        PsiAnnotationMemberValue value;
        String str;
        AnnotationGenericValue<T> annotationGenericValue;
        if (!(annotation != null ? (annotationGenericValue = AnnotationGenericValue.getLazyInstance(str = AnnotationModelUtil.getObjectValue(value = annotation.findAttributeValue(attributeName), String.class), annotation, value, converter)) != null : (annotationGenericValue = AnnotationGenericValue.NULL) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getLazyObjectValue must not return null");
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<String> getStringValue(PsiAnnotation annotation, @NonNls String attributeName, @Nullable String defaultValue) {
        PsiAnnotationMemberValue value;
        String obj;
        String result;
        AnnotationGenericValue<String> annotationGenericValue;
        if (!(annotation != null ? (annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote(result = (obj = AnnotationModelUtil.getObjectValue(value = annotation.findDeclaredAttributeValue(attributeName), String.class)) == null ? defaultValue : obj), annotation, value)) != null : (defaultValue != null ? (annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote(defaultValue), null, null)) != null : (annotationGenericValue = AnnotationGenericValue.NULL) != null))) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getStringValue must not return null");
        }
        return annotationGenericValue;
    }

    @NotNull
    public static <T> AnnotationGenericValue<T> getObjectValue(PsiAnnotation annotation, @NonNls String attributeName, Class<T> clazz) {
        PsiAnnotationMemberValue value;
        T obj;
        AnnotationGenericValue<T> annotationGenericValue;
        if (!(annotation != null ? (annotationGenericValue = AnnotationGenericValue.getInstance(obj = AnnotationModelUtil.getObjectValue(value = annotation.findAttributeValue(attributeName), clazz), annotation, value)) != null : (annotationGenericValue = AnnotationGenericValue.NULL) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getObjectValue must not return null");
        }
        return annotationGenericValue;
    }

    @Nullable
    public static <T> T getObjectValue(@Nullable PsiAnnotationMemberValue value, Class<T> clazz) {
        Object obj;
        boolean isString;
        boolean bl = isString = clazz == String.class;
        if (ReflectionCache.isAssignable(Enum.class, clazz)) {
            return AnnotationModelUtil.getEnumValue(value, clazz);
        }
        if (value instanceof PsiExpression && (obj = JamCommonUtil.computeMemberValue(value)) != null && ReflectionCache.isAssignable(clazz, obj.getClass())) {
            return (T)(isString ? StringUtil.stripQuotesAroundValue((String)obj) : obj);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static AnnotationGenericValue<PsiClass> getPsiClassValue(PsiAnnotation annotation, String attributeName, PsiClass defaultValue) {
        AnnotationGenericValue<PsiClass> annotationGenericValue;
        if (annotation != null) {
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            PsiClass psiClass = AnnotationModelUtil.getPsiClass(memberValue);
            if (psiClass == null) {
                psiClass = defaultValue;
            }
            if (psiClass != null || memberValue != null) {
                annotationGenericValue = AnnotationGenericValue.getInstance(psiClass, annotation, memberValue);
                if (annotationGenericValue == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getPsiClassValue must not return null");
                return annotationGenericValue;
            }
        }
        if ((annotationGenericValue = AnnotationGenericValue.NULL) != null) return annotationGenericValue;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getPsiClassValue must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static AnnotationGenericValue<PsiClass> getDeclaredPsiClassValue(PsiAnnotation annotation, String attributeName, PsiClass defaultValue) {
        AnnotationGenericValue<PsiClass> annotationGenericValue;
        if (annotation != null) {
            PsiAnnotationMemberValue memberValue = annotation.findDeclaredAttributeValue(attributeName);
            PsiClass psiClass = AnnotationModelUtil.getPsiClass(memberValue);
            if (psiClass == null) {
                psiClass = defaultValue;
            }
            if (psiClass != null || memberValue != null) {
                annotationGenericValue = AnnotationGenericValue.getInstance(psiClass, annotation, memberValue);
                if (annotationGenericValue == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getDeclaredPsiClassValue must not return null");
                return annotationGenericValue;
            }
        }
        if ((annotationGenericValue = AnnotationGenericValue.NULL) != null) return annotationGenericValue;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getDeclaredPsiClassValue must not return null");
    }

    @Nullable
    public static PsiClass getPsiClass(PsiAnnotationMemberValue psiAnnotationMemberValue) {
        Object value;
        PsiClass psiClass = null;
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)psiAnnotationMemberValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
        } else if (psiAnnotationMemberValue instanceof PsiExpression && (value = JamCommonUtil.computeMemberValue(psiAnnotationMemberValue)) instanceof String) {
            String className = StringUtil.stripQuotesAroundValue((String)value);
            psiClass = psiAnnotationMemberValue.getManager().findClass(className, psiAnnotationMemberValue.getResolveScope());
        }
        if (psiClass != null && "java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        return psiClass;
    }

    @Nullable
    public static AnnotationGenericValue<PsiClass> createPsiClassValue(PsiAnnotation annotation, PsiAnnotationMemberValue psiAnnotationMemberValue) {
        PsiClass psiClass = AnnotationModelUtil.getPsiClass(psiAnnotationMemberValue);
        return psiClass == null ? null : AnnotationGenericValue.getInstance(psiClass, annotation, psiAnnotationMemberValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<AnnotationGenericValue<PsiClass>> getPsiClassArrayValue(PsiAnnotation annotation, String attributeName) {
        List<AnnotationGenericValue<PsiClass>> list;
        if (annotation != null) {
            PsiClass psiClass;
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            if (memberValue instanceof PsiArrayInitializerMemberValue) {
                ArrayList<AnnotationGenericValue<PsiClass>> result = new ArrayList<AnnotationGenericValue<PsiClass>>();
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)memberValue;
                for (PsiAnnotationMemberValue value : arrayValue.getInitializers()) {
                    PsiClass psiClass2 = AnnotationModelUtil.getPsiClass(value);
                    if (psiClass2 == null) continue;
                    result.add(AnnotationGenericValue.getInstance(psiClass2, annotation, value));
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getPsiClassArrayValue must not return null");
                return list;
            }
            if (memberValue != null && (psiClass = AnnotationModelUtil.getPsiClass(memberValue)) != null) {
                list = Collections.singletonList(AnnotationGenericValue.getInstance(psiClass, annotation, memberValue));
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getPsiClassArrayValue must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/javaee/model/annotations/AnnotationModelUtil.getPsiClassArrayValue must not return null");
    }

    public static void findAnnotatedPsiMembers(String annotationClass, PsiManager psiManager, Module module, Processor<PsiMember> processor) {
        AnnotationModelUtil.findAnnotatedPsiMembers(annotationClass, psiManager, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module), processor);
    }

    private static void findAnnotatedPsiMembers(String annotationClass, PsiManager psiManager, GlobalSearchScope scope, Processor<PsiMember> processor) {
        PsiClass aClass = psiManager.findClass(annotationClass, GlobalSearchScope.allScope(psiManager.getProject()));
        if (aClass != null) {
            AnnotatedMembersSearch.search(aClass, scope).forEach(processor);
        }
    }

    public static <T extends JamElement> void processAnnotatedElements(String annotationClass, final Class<T> elementClass, PsiManager psiManager, Module module, final Processor<T> processor) {
        AnnotationModelUtil.findAnnotatedPsiMembers(annotationClass, psiManager, module, new Processor<PsiMember>(){

            @Override
            public boolean process(PsiMember psiMember) {
                for (JamMemberElement<PsiMember> annotatedElement = AnnotationModelUtil.getFirstAnnotatedElement(psiMember); annotatedElement != null; annotatedElement = annotatedElement.getNextElement()) {
                    if (!AnnotationModelUtil.checkIsValid(annotatedElement) || !ReflectionCache.isAssignable(elementClass, annotatedElement.getClass())) continue;
                    return processor.process(annotatedElement);
                }
                return true;
            }
        });
    }

    private static JamMemberElement getFirstAnnotatedElement(PsiMember psiMember) {
        return JamManager.getInstance(psiMember.getProject()).getFirstMemberElement(psiMember);
    }

    public static <T extends JamElement> List<T> findAnnotatedElements(String annotationClass, List<T> result, Class<T> elementClass, PsiManager psiManager, Module module) {
        AnnotationModelUtil.processAnnotatedElements(annotationClass, elementClass, psiManager, module, new CommonProcessors.CollectProcessor<T>(result));
        return result;
    }

    @Nullable
    public static String getPsiMemberName(PsiMember member) {
        String attributeName = PropertyUtil.getPropertyName(member);
        return attributeName == null ? null : member.getContainingClass().getQualifiedName() + "/" + attributeName;
    }

    @Nullable
    public static PsiClass getPsiMemberType(PsiMember member) {
        PsiTypeElement typeElement = AnnotationModelUtil.getPsiMemberTypeElement(member);
        if (typeElement != null) {
            PsiType psiType = typeElement.getType();
            return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : (TypeConversionUtil.isPrimitiveAndNotNull(psiType) ? member.getManager().findClass(((PsiPrimitiveType)psiType).getBoxedTypeName(), member.getResolveScope()) : null);
        }
        return null;
    }

    @Nullable
    public static PsiTypeElement getPsiMemberTypeElement(PsiMember member) {
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertySetter(method)) {
                return method.getParameterList().getParameters()[0].getTypeElement();
            }
            if (PropertyUtil.isSimplePropertyGetter(method)) {
                return method.getReturnTypeElement();
            }
        } else if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        return null;
    }

    public static <T extends JamMemberElement> List<T> getAnnotatedMembersList(PsiClass psiClass, final Class<T> clazz, boolean checkClass, boolean checkMethods, boolean checkFields, boolean checkDeep) {
        if (psiClass == null) {
            return Collections.emptyList();
        }
        final ArrayList annotatedMemberList = new ArrayList();
        Processor<PsiMember> processor = new Processor<PsiMember>(){

            @Override
            public boolean process(PsiMember member) {
                annotatedMemberList.addAll(AnnotationModelUtil.getAnnotatedElements(member, clazz));
                return true;
            }
        };
        if (checkClass) {
            if (checkDeep) {
                for (PsiClass curClass : JamCommonUtil.getSuperClassList(psiClass)) {
                    processor.process(curClass);
                }
            } else {
                processor.process(psiClass);
            }
        }
        if (checkMethods) {
            ContainerUtil.process(Arrays.asList(checkDeep ? psiClass.getAllMethods() : psiClass.getMethods()), processor);
        }
        if (checkFields) {
            ContainerUtil.process(Arrays.asList(checkDeep ? psiClass.getAllFields() : psiClass.getFields()), processor);
        }
        return annotatedMemberList;
    }

    public static List<PsiAnnotation> getAnnotationsValueIncludingSingle(PsiModifierListOwner modifierListOwner, String annotationName, String contentAnnotation) {
        if (modifierListOwner == null) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotation psiSingleAnnotation = modifierList.findAnnotation(contentAnnotation);
        if (psiSingleAnnotation != null) {
            result.add(psiSingleAnnotation);
        }
        PsiAnnotation annotation = modifierList.findAnnotation(annotationName);
        for (PsiAnnotation psiAnnotation : AnnotationModelUtil.getAnnotationsValue(annotation, "value", contentAnnotation)) {
            result.add(psiAnnotation);
        }
        return result;
    }
}

