/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.javaee.model.annotations.AnnotationElement;
import com.intellij.javaee.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.xml.ReadOnlyGenericValue;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationGenericValue<T>
extends ReadOnlyGenericValue<T>
implements AnnotationElement {
    public static final AnnotationGenericValue NULL = AnnotationGenericValue.getInstanceInternal(null, null, null);

    public static <T> AnnotationGenericValue<T> nullInstance() {
        return NULL;
    }

    public static <T> AnnotationGenericValue<T> getInstance(@Nullable T value, PsiAnnotation annotation, PsiAnnotationMemberValue definingElement) {
        return value == null && annotation == null ? NULL : AnnotationGenericValue.getInstanceInternal(value, annotation, definingElement);
    }

    private static <T> AnnotationGenericValue<T> getInstanceInternal(final T value, final PsiAnnotation annotation, final PsiAnnotationMemberValue definingElement) {
        return new AnnotationGenericValue<T>(){

            @Override
            public PsiAnnotation getIdentifyingAnnotation() {
                return annotation;
            }

            @Override
            public PsiAnnotationMemberValue getDefiningElement() {
                return definingElement;
            }

            @Override
            public boolean isValid() {
                return annotation.isValid() && (definingElement == null || definingElement.isValid());
            }

            @Override
            public Module getModule() {
                return ModuleUtil.findModuleForPsiElement(annotation);
            }

            @Override
            public PsiManager getPsiManager() {
                return annotation.getManager();
            }

            @Override
            public T getValue() {
                return value;
            }

            @Override
            public String getStringValue() {
                if (value != null) {
                    if (value instanceof String) {
                        return (String)value;
                    }
                    if (value instanceof PsiClass) {
                        return ((PsiClass)value).getQualifiedName();
                    }
                }
                if (definingElement != null) {
                    if (definingElement instanceof PsiClassObjectAccessExpression) {
                        return ((PsiClassObjectAccessExpression)definingElement).getOperand().getType().getCanonicalText();
                    }
                    Object o = JamCommonUtil.computeMemberValue(definingElement);
                    if (o instanceof String) {
                        return (String)o;
                    }
                    return definingElement.getText();
                }
                return null;
            }
        };
    }

    public static <T> AnnotationGenericValue<T> getLazyInstance(final String text, final PsiAnnotation annotation, final PsiAnnotationMemberValue definingElement, final Function<String, T> converter) {
        return new AnnotationGenericValue<T>(){
            private T value;

            @Override
            public PsiAnnotation getIdentifyingAnnotation() {
                return annotation;
            }

            @Override
            public PsiAnnotationMemberValue getDefiningElement() {
                return definingElement;
            }

            @Override
            public boolean isValid() {
                return annotation.isValid() && (definingElement == null || definingElement.isValid());
            }

            @Override
            public Module getModule() {
                return ModuleUtil.findModuleForPsiElement(annotation);
            }

            @Override
            public PsiManager getPsiManager() {
                return annotation.getManager();
            }

            @Override
            public T getValue() {
                return this.value != null ? this.value : (this.value = converter.fun(text));
            }

            @Override
            public String getStringValue() {
                if (this.value == null) {
                    return text;
                }
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                if (this.value instanceof PsiClass) {
                    return ((PsiClass)this.value).getQualifiedName();
                }
                if (definingElement == null) {
                    return null;
                }
                Object o = JamCommonUtil.computeMemberValue(definingElement);
                if (o instanceof String) {
                    return (String)o;
                }
                return definingElement.getText();
            }
        };
    }
}

