/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.ui;

import com.intellij.javaee.JamMessages;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.TableViewModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectElementsDialog
extends DialogWrapper {
    private final TableView myTable;
    final Set<PsiElement> mySelectedElements = new HashSet<PsiElement>();
    private final Project myProject;
    private final ColumnInfo myIsSelected = new ColumnInfo<PsiElement, Boolean>(""){

        @Override
        public Boolean valueOf(PsiElement psiElement) {
            return SelectElementsDialog.this.mySelectedElements.contains(psiElement);
        }

        @Override
        public boolean isCellEditable(PsiElement psiElement) {
            return true;
        }

        @Override
        public Class getColumnClass() {
            return Boolean.TYPE;
        }

        @Override
        public TableCellRenderer getRenderer(final PsiElement psiElement) {
            return new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JCheckBox result = new JCheckBox();
                    result.setBackground(table.getBackground());
                    result.setSelected(SelectElementsDialog.this.mySelectedElements.contains(psiElement));
                    return result;
                }
            };
        }

        @Override
        public int getWidth(JTable table) {
            return new JCheckBox().getPreferredSize().width + 2;
        }

        @Override
        public TableCellEditor getEditor(PsiElement psiElement) {
            return new DefaultCellEditor(new JCheckBox());
        }

        @Override
        public void setValue(PsiElement psiElement, Boolean aBoolean) {
            if (aBoolean.booleanValue()) {
                SelectElementsDialog.this.mySelectedElements.add(psiElement);
            } else {
                SelectElementsDialog.this.mySelectedElements.remove(psiElement);
            }
            SelectElementsDialog.this.onSelectionChanged();
        }
    };
    private final ColumnInfo myName = new ColumnInfo<PsiElement, String>(""){

        @Override
        public String valueOf(PsiElement psiElement) {
            return SelectElementsDialog.this.getPresentableText(psiElement);
        }

        @Override
        public TableCellRenderer getRenderer(final PsiElement psiElement) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (!psiElement.isPhysical()) {
                        this.append("  [" + JamMessages.message("postfix.not.physical.element", new Object[0]) + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                    this.setIcon(psiElement.getIcon(0));
                }
            };
        }
    };

    protected void onSelectionChanged() {
    }

    private String getPresentableText(PsiElement psiElement) {
        NavigationItem navigationItem;
        ItemPresentation presentation;
        if (psiElement instanceof PsiFile) {
            return ((PsiFile)psiElement).getName();
        }
        if (psiElement instanceof PsiClass) {
            return PsiFormatUtil.formatClass((PsiClass)psiElement, 2049);
        }
        if (psiElement instanceof PsiMethod) {
            return PsiFormatUtil.formatMethod((PsiMethod)psiElement, PsiSubstitutor.EMPTY, 4353, 0);
        }
        if (psiElement instanceof PsiField) {
            return PsiFormatUtil.formatVariable((PsiField)psiElement, 4099, PsiSubstitutor.EMPTY);
        }
        if (psiElement instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)psiElement;
            return xmlTag.getContainingFile().getName() + ": <" + xmlTag.getName() + ">";
        }
        if (psiElement instanceof PsiAnnotation) {
            PsiAnnotation annotation = (PsiAnnotation)psiElement;
            PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class, true);
            if (member != null) {
                return this.getPresentableText(member) + ": @" + annotation.getQualifiedName();
            }
            return annotation.getContainingFile().getName() + ": @" + annotation.getQualifiedName();
        }
        if (psiElement instanceof NavigationItem && (presentation = (navigationItem = (NavigationItem)((Object)psiElement)).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return ((Object)psiElement).toString();
    }

    public SelectElementsDialog(Project project, List<PsiElement> elements, String title, String elementsTitle) {
        super(true);
        this.myProject = project;
        this.myName.setName(elementsTitle);
        this.myTable = new TableView(new ListTableModel(this.myIsSelected, this.myName));
        TableViewModel model = this.myTable.getTableViewModel();
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>(elements);
        Collections.sort(arrayList, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                int filesResult = Comparing.compare(o1.getContainingFile().getName(), o2.getContainingFile().getName());
                if (filesResult != 0) {
                    return filesResult;
                }
                return SelectElementsDialog.this.getPresentableText(o1).compareTo(SelectElementsDialog.this.getPresentableText(o2));
            }
        });
        model.setItems(arrayList);
        model.setSortable(false);
        this.setTitle(title);
        this.init();
        this.onSelectionChanged();
    }

    @Override
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Override
    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane(this.myTable.getComponent());
    }

    public Collection<PsiElement> getSelectedItems() {
        return this.mySelectedElements;
    }
}

