/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.treetable;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamAbstractTreeBuilder;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamSpacerColumnInfo;
import com.intellij.jam.view.treetable.JamToolTipRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftArrayHashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.ui.treetable.TreeTableCellRenderer;
import com.intellij.util.ui.treetable.TreeTableModel;
import com.intellij.util.ui.treetable.TreeTableTree;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.EmptyPane;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JamTreeTableView
implements CommittablePanel,
DataProvider {
    private static final DefaultTableCellRenderer LOADING_NODE_RENDERER = new DefaultTableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText("");
            return cellRendererComponent;
        }
    };
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String EMPTY = "empty";
    private final CardLayout myCardLayout;
    private final JPanel myContentPanel = new JPanel();
    private final EmptyPane myEmptyPane = new EmptyPane("If you see this text, please, submit a bug");
    private final JPanel myPanel = new PanelToViewDataDelegator();
    private final TreeTableView myTreeTableView;
    private final JamAbstractTreeBuilder myBuilder;
    private final Project myProject;
    private final JamNodeDescriptor myRootDescriptor;
    private final ListTreeTableModelOnColumns myModel;
    private final SoftArrayHashMap<Object, List<Object>> myCache = new SoftArrayHashMap();
    private boolean myTreeShowing = false;

    public JamTreeTableView(Project project, JamNodeDescriptor rootDescriptor) {
        this.myProject = project;
        this.myRootDescriptor = rootDescriptor;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.myModel = new ListTreeTableModelOnColumns(rootNode, ColumnInfo.EMPTY_ARRAY){

            public boolean isCellEditable(Object node, int column) {
                try {
                    return super.isCellEditable(JamTreeTableView.getJamNodeDescriptor(node), column);
                }
                catch (LoadingNodeException e) {
                    return false;
                }
            }

            public void setValueAt(Object aValue, Object node, int column) {
                try {
                    ColumnInfo columnInfo = this.getColumnInfos()[column];
                    JamNodeDescriptor descriptor = JamTreeTableView.getJamNodeDescriptor(node);
                    JamTreeTableView.this.getCachedColumnValues(((DefaultMutableTreeNode)node).getUserObjectPath()).set(column, aValue);
                    JamTreeTableView.this.setValueAt(columnInfo, descriptor, aValue);
                }
                catch (LoadingNodeException e) {
                    // empty catch block
                }
            }

            public Object getValueAt(Object value, int column) {
                return JamTreeTableView.this.getCachedColumnValues(((DefaultMutableTreeNode)value).getUserObjectPath()).get(column);
            }
        };
        this.myTreeTableView = new MyTreeTableView(this.myModel);
        this.myBuilder = new JamAbstractTreeBuilder(project, this.getTree(), this.myModel, rootDescriptor){

            protected boolean updateNodeDescriptor(NodeDescriptor descriptor) {
                boolean result = super.updateNodeDescriptor(descriptor);
                if ((!descriptor.equals(JamTreeTableView.this.myRootDescriptor) || this.getTree().isRootVisible()) && ((JamNodeDescriptor)descriptor).isValid()) {
                    JamTreeTableView.this.cacheNode((JamNodeDescriptor)descriptor);
                }
                return result;
            }

            public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return false;
            }
        };
        Disposer.register(this, this.myBuilder);
        this.myTreeTableView.setDragEnabled(false);
        this.myTreeTableView.getSelectionModel().setSelectionMode(0);
        this.myTreeTableView.setRowHeight(Icons.CLASS_ICON.getIconHeight());
        JTableHeader header = this.myTreeTableView.getTableHeader();
        header.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                JamTreeTableView.this.updateTooltip(e);
            }
        });
        header.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JamTreeTableView.this.updateTooltip(e);
            }
        });
        header.setReorderingAllowed(false);
        this.getTree().setShowsRootHandles(true);
        UIUtil.setLineStyleAngled(this.getTree());
        this.getTree().setCellRenderer(new JamToolTipRenderer());
        this.getTree().getSelectionModel().setSelectionMode(0);
        EditSourceOnDoubleClickHandler.install(this.myTreeTableView);
        this.myBuilder.init();
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myContentPanel, "Center");
        this.myCardLayout = new CardLayout();
        this.myContentPanel.setLayout(this.myCardLayout);
        this.myContentPanel.add((Component)this.myEmptyPane.getComponent(), EMPTY);
        this.myContentPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTreeTableView), TREE);
    }

    protected final void updateTooltip(MouseEvent e) {
        int i = this.myTreeTableView.columnAtPoint(e.getPoint());
        if (i >= 0) {
            this.myTreeTableView.getTableHeader().setToolTipText(this.getColumnInfos()[i].getTooltipText());
        }
    }

    protected void setValueAt(ColumnInfo columnInfo, JamNodeDescriptor descriptor, Object aValue) {
        columnInfo.setValue(descriptor, aValue);
        this.reset();
    }

    protected final void init() {
        ActionGroup actionGroup;
        JComponent toolbar = this.createToolbar();
        if (toolbar != null) {
            this.myPanel.add((Component)toolbar, "North");
        }
        if ((actionGroup = this.createActionGroup(true)) != null) {
            PopupHandler.installPopupHandler(this.myEmptyPane.getComponent(), actionGroup, "J2EEAttributesViewPopup", ActionManager.getInstance());
            PopupHandler.installPopupHandler(this.myTreeTableView, actionGroup, "J2EEAttributesViewPopup", ActionManager.getInstance());
        }
        this.reset();
        TreeUtil.expandAll(this.getTree());
    }

    public final TreeTableView getTreeTableView() {
        return this.myTreeTableView;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final Tree getTree() {
        return this.myTreeTableView.getTree();
    }

    public final void refreshTreeTable() {
        boolean visibilityChanged;
        boolean showTree = this.isShowTree();
        boolean bl = visibilityChanged = showTree != this.myTreeShowing;
        if (visibilityChanged || showTree) {
            TreePath[] selection = this.myTreeTableView.getTree().getSelectionPaths();
            this.cacheValues();
            this.myBuilder.setWaiting(false);
            this.myBuilder.updateFromRoot();
            if (!this.getTree().isExpanded(0)) {
                TreeUtil.expandRootChildIfOnlyOne(this.getTree());
            }
            this.myTreeTableView.getSelectionModel().clearSelection();
            if (selection != null) {
                for (TreePath treePath : selection) {
                    int row = this.myTreeTableView.getTree().getRowForPath(treePath);
                    this.myTreeTableView.getSelectionModel().addSelectionInterval(row, row);
                }
            }
        }
        if (!showTree) {
            this.myEmptyPane.setText("<html>" + this.getEmptyPaneText() + "</html>");
        }
        if (visibilityChanged) {
            this.myTreeShowing = showTree;
            if (showTree) {
                TreeUtil.expandRootChildIfOnlyOne(this.getTree());
                this.myCardLayout.show(this.myContentPanel, TREE);
            } else {
                this.myCardLayout.show(this.myContentPanel, EMPTY);
            }
            this.myContentPanel.requestFocus();
        }
    }

    protected void setColumnsPreferredWidth() {
        ColumnInfo[] columnInfos = this.getColumnInfos();
        TableColumnModel columnModel = this.myTreeTableView.getColumnModel();
        JTableHeader header = this.myTreeTableView.getTableHeader();
        FontMetrics fontMetrics = header.getFontMetrics(header.getFont());
        int maxPreferredWidth = 0;
        TableColumn treeColumn = null;
        for (int i = 0; i < columnInfos.length; ++i) {
            ColumnInfo columnInfo = columnInfos[i];
            TableColumn column = columnModel.getColumn(i);
            String name = columnInfo.getName();
            int minWidth = StringUtil.isNotEmpty(name.trim()) ? fontMetrics.stringWidth(name) + 15 : 0;
            column.setMinWidth(minWidth);
            if (TreeTableModel.class.isAssignableFrom(columnInfo.getColumnClass())) {
                treeColumn = column;
                int preferredWidth = this.myTreeTableView.getTree().getSize().width;
                column.setPreferredWidth(preferredWidth);
                if (preferredWidth > minWidth) {
                    column.setMinWidth(preferredWidth);
                }
            } else if (!(columnInfo instanceof JamSpacerColumnInfo)) {
                int fixedWidth = columnInfo.getWidth(this.myTreeTableView);
                if (fixedWidth > 0) {
                    int realWidth = Math.max(minWidth, fixedWidth);
                    column.setMaxWidth(realWidth);
                    column.setMinWidth(realWidth);
                    column.setPreferredWidth(realWidth);
                } else {
                    int preferredWidth = minWidth;
                    String preferredValue = columnInfo.getPreferredStringValue();
                    if (preferredValue != null) {
                        preferredWidth = Math.max(preferredWidth, fontMetrics.stringWidth(preferredValue));
                    }
                    column.setPreferredWidth(preferredWidth + columnInfo.getAdditionalWidth());
                    String maxValue = columnInfo.getMaxStringValue();
                    if (maxValue != null) {
                        column.setMaxWidth(fontMetrics.stringWidth(preferredValue) + columnInfo.getAdditionalWidth());
                    }
                }
            }
            maxPreferredWidth = Math.max(maxPreferredWidth, column.getPreferredWidth());
        }
        if (treeColumn != null && treeColumn.getPreferredWidth() < 4 * maxPreferredWidth) {
            treeColumn.setPreferredWidth(4 * maxPreferredWidth);
        }
    }

    @Nullable
    protected ActionGroup createActionGroup(boolean isPopup) {
        return isPopup ? this.createPopupActionGroup() : this.createToolbarActions();
    }

    @Nullable
    protected ActionGroup createPopupActionGroup() {
        return null;
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        return null;
    }

    @Nullable
    protected JComponent createToolbar() {
        ActionGroup actionGroup = this.createActionGroup(false);
        if (actionGroup == null) {
            return null;
        }
        JComponent component = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", actionGroup, true).getComponent();
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), component.getBorder()));
        return component;
    }

    @Override
    public void dispose() {
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public void reset() {
        boolean columnsChanged = this.myModel.setColumns(this.createColumnInfos());
        this.refreshTreeTable();
        AbstractTableModel tableModel = (AbstractTableModel)this.myTreeTableView.getModel();
        if (columnsChanged) {
            tableModel.fireTableStructureChanged();
            this.setColumnsPreferredWidth();
        }
        if (this.myTreeShowing) {
            tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void commit() {
    }

    protected void cacheValues() {
        this.myCache.clear();
    }

    protected void recacheColumn(final int columnIndex) {
        assert (columnIndex >= 0 && columnIndex < this.getColumnInfos().length);
        final ColumnInfo columnInfo = this.getColumnInfos()[columnIndex];
        this.myCache.processLeafEntries(new PairProcessor<Object, List<Object>>(){

            @Override
            public boolean process(Object o, List<Object> objects) {
                objects.set(columnIndex, columnInfo.valueOf(o));
                return true;
            }
        });
    }

    private static JamNodeDescriptor getJamNodeDescriptor(Object nodeDescriptor) throws LoadingNodeException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeDescriptor;
        if (AbstractTreeBuilder.isLoadingNode(node)) {
            throw new LoadingNodeException();
        }
        return (JamNodeDescriptor)node.getUserObject();
    }

    protected final void setCachedValue(Object value, int column, Object ... path) {
        Object[] path1 = this.getDescriptorPath(path);
        if (path1 == null) {
            return;
        }
        this.getCachedColumnValues(path1).set(column, value);
    }

    private static JamNodeDescriptor[] getDescriptorPath(JamNodeDescriptor descriptor) {
        LinkedList<JamNodeDescriptor> list = new LinkedList<JamNodeDescriptor>();
        while (descriptor != null) {
            list.addFirst(descriptor);
            descriptor = (JamNodeDescriptor)descriptor.getParent();
        }
        return list.toArray(new JamNodeDescriptor[list.size()]);
    }

    @Nullable
    private JamNodeDescriptor[] getDescriptorPath(Object ... path) {
        assert (JamTreeTableView.corresponds(this.myRootDescriptor, path[0]));
        JamNodeDescriptor[] result = new JamNodeDescriptor[path.length];
        result[0] = this.myRootDescriptor;
        DefaultMutableTreeNode parent = this.myBuilder.getRootNode();
        for (int i = 1; i < path.length; ++i) {
            DefaultMutableTreeNode treeNode;
            final Object pathElement = path[i];
            DefaultMutableTreeNode defaultMutableTreeNode = treeNode = parent == null ? null : this.myBuilder.getNodeForElement(pathElement);
            if (treeNode == null || !parent.equals(treeNode.getParent())) {
                result[i] = ContainerUtil.find(result[i - 1].getChildren(), new Condition<JamNodeDescriptor>(){

                    @Override
                    public boolean value(JamNodeDescriptor object) {
                        return JamTreeTableView.corresponds(object, pathElement);
                    }
                });
                parent = treeNode;
            } else {
                result[i] = (JamNodeDescriptor)treeNode.getUserObject();
                parent = null;
            }
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    private static boolean corresponds(JamNodeDescriptor object, Object pathElement) {
        return Comparing.equal(object.getElement(), pathElement);
    }

    private List<Object> getCachedColumnValues(Object[] path) {
        if (!this.myCache.containsKey((Object[])path)) {
            this.myCache.put((Object[])path, new ArrayList<Object>(this.getEmptyColumnValues()));
        }
        return this.myCache.get((Object[])path);
    }

    protected void cacheNode(JamNodeDescriptor node) {
        JamNodeDescriptor[] path = JamTreeTableView.getDescriptorPath(node);
        if (!this.myCache.containsKey((Object[])path)) {
            this.myCache.put((Object[])path, this.getColumnValues(node));
        }
    }

    private List<Object> getColumnValues(final JamNodeDescriptor descriptor) {
        return ContainerUtil.map2List(this.getColumnInfos(), new Function<ColumnInfo, Object>(){

            @Override
            public Object fun(ColumnInfo s) {
                return s.valueOf(descriptor);
            }
        });
    }

    protected List<Object> getEmptyColumnValues() {
        return Arrays.asList(new Object[this.getColumnInfos().length]);
    }

    protected ColumnInfo[] getColumnInfos() {
        return this.myModel.getColumnInfos();
    }

    protected abstract boolean isShowTree();

    @NotNull
    protected String getEmptyPaneText() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/jam/view/treetable/JamTreeTableView.getEmptyPaneText must not return null");
        }
        return "";
    }

    protected abstract ColumnInfo[] createColumnInfos();

    @Nullable
    private Object getSelectedElement() {
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        return descriptor == null ? null : descriptor.getElement();
    }

    @Nullable
    public final NodeDescriptor getSelectedDescriptor() {
        Object lastPathComponent;
        TreePath path = this.getSelectedPath();
        if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            try {
                return JamTreeTableView.getJamNodeDescriptor(lastPathComponent);
            }
            catch (LoadingNodeException loadingNodeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private TreePath getSelectedPath() {
        TreePath[] paths = this.getTree() == null ? null : this.getTree().getSelectionPaths();
        return paths != null && paths.length == 1 ? paths[0] : null;
    }

    @Override
    public Object getData(String dataId) {
        if ("psi.Element".equals(dataId)) {
            Object element = this.getSelectedElement();
            return element instanceof PsiElement && ((PsiElement)element).isValid() ? element : null;
        }
        if ("psi.File".equals(dataId)) {
            Object element = this.getSelectedElement();
            return element instanceof PsiFile ? element : null;
        }
        if ("project".equals(dataId)) {
            return this.myProject;
        }
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor instanceof JamNodeDescriptor) {
            return ((JamNodeDescriptor)descriptor).getDataForElement(dataId);
        }
        return null;
    }

    protected void setCachedValues(Object value, Collection<Integer> columns, Object ... url) {
        for (int column : columns) {
            this.setCachedValue(value, column, url);
        }
    }

    private static class MyTreeTableView
    extends TreeTableView {
        public MyTreeTableView(ListTreeTableModelOnColumns model) {
            super(model);
        }

        public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
            final TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
            tableRenderer.setDefaultBorder(null);
            final TreeTableTree tree = this.getTree();
            return new TreeTableCellRenderer(this, tree){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component1 = tableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    tree.setCellFocused(true);
                    return component1;
                }
            };
        }

        protected final Object getRowElement(int row) {
            try {
                return JamTreeTableView.getJamNodeDescriptor(super.getRowElement(row));
            }
            catch (LoadingNodeException e) {
                return null;
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            try {
                JamNodeDescriptor node = JamTreeTableView.getJamNodeDescriptor(super.getRowElement(row));
                return this.getColumnInfo(column).getCustomizedRenderer(node, new StripeTableCellRenderer(super.getCellRenderer(row, column)));
            }
            catch (LoadingNodeException e) {
                return LOADING_NODE_RENDERER;
            }
        }
    }

    private class PanelToViewDataDelegator
    extends JPanel
    implements DataProvider {
        private PanelToViewDataDelegator() {
        }

        public Object getData(String dataId) {
            return JamTreeTableView.this.getData(dataId);
        }
    }

    private static class LoadingNodeException
    extends Exception {
        private LoadingNodeException() {
        }
    }
}

