/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.javaee.CommonModelManager;
import com.intellij.javaee.model.common.CommonModelElement;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ReflectionCache;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JamObjectDescriptor<P extends CommonModelElement>
extends JamNodeDescriptor<P> {
    @NonNls
    public static final DataKey<CommonModelElement> SELECTED_COMMON_MODEL_ELEMENT = DataKey.create("SELECTED_COMMON_MODEL_ELEMENT");

    protected JamObjectDescriptor(P element, NodeDescriptor parentDescriptor, Object parameters) {
        super(parentDescriptor.getProject(), parentDescriptor, parameters, element);
    }

    protected JamObjectDescriptor(P element, Project project, Object parameters) {
        super(project, null, parameters, element);
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        DefaultUserResponse response = new DefaultUserResponse(this.myProject);
        return new JamDeleteProvider((CommonModelElement)this.getElement(), response);
    }

    @Override
    public P updateElement() {
        CommonModelElement element = (CommonModelElement)this.getElement();
        if (!element.isValid()) {
            return null;
        }
        return (P)((CommonModelElement)this.getElement());
    }

    @Override
    public String getNewTooltip() {
        return null;
    }

    @Override
    public boolean isValid() {
        return ((CommonModelElement)this.getElement()).isValid();
    }

    @Override
    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + textExt + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        return null;
    }

    @Override
    public Object getData(String dataId) {
        Navigatable navigatable;
        if (SELECTED_COMMON_MODEL_ELEMENT.getName().equals(dataId)) {
            return this.getElement();
        }
        if ("Navigatable".equals(dataId) && (navigatable = this.getNavigatable()) != null) {
            return navigatable;
        }
        if ("psi.Element".equals(dataId)) {
            CommonModelElement element = (CommonModelElement)this.getElement();
            return element.isValid() ? element.getIdentifyingPsiElement() : null;
        }
        if ("module".equals(dataId)) {
            return this.getParentElementOfType(Module.class);
        }
        return super.getData(dataId);
    }

    @Nullable
    public <T> T getParentElementOfType(Class<T> elementClass) {
        for (NodeDescriptor cur = this; cur != null; cur = cur.getParentDescriptor()) {
            Object element = ((NodeDescriptor)cur).getElement();
            if (element == null || !ReflectionCache.isAssignable(elementClass, element.getClass())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    protected Navigatable getNavigatable() {
        PsiFile file;
        VirtualFile virtualFile;
        XmlFile file2;
        VirtualFile virtualFile2;
        Object domElement = CommonModelManager.getInstance().getDomElement((CommonModelElement)this.getElement());
        if (domElement != null && domElement.getXmlTag() != null && (virtualFile2 = (file2 = domElement.getRoot().getFile()).getVirtualFile()) != null && virtualFile2.isValid()) {
            return new OpenFileDescriptor(file2.getManager().getProject(), virtualFile2, domElement.getXmlTag().getTextRange().getStartOffset());
        }
        Object annoElement = CommonModelManager.getInstance().getJamElement((CommonModelElement)this.getElement());
        if (annoElement != null && annoElement.getIdentifyingAnnotation() != null && (virtualFile = (file = annoElement.getIdentifyingAnnotation().getContainingFile()).getVirtualFile()) != null && virtualFile.isValid()) {
            return new OpenFileDescriptor(file.getManager().getProject(), virtualFile, annoElement.getIdentifyingAnnotation().getTextRange().getStartOffset());
        }
        return null;
    }
}

