/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.JamMessages;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JamNodeDescriptor<P>
extends SimpleNode
implements DataProvider {
    public static final JamNodeDescriptor[] EMPTY_ARRAY = new JamNodeDescriptor[0];
    private final Object myParameters;
    private P myElement;
    private String myTooltip;

    protected JamNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, P element) {
        super(project, parentDescriptor);
        this.myParameters = parameters;
        this.myElement = element;
    }

    @Override
    public Object[] getEqualityObjects() {
        return new Object[]{this.myElement};
    }

    @Override
    protected void doUpdate() {
        this.setIcons(this.getNewClosedIcon(), this.getNewOpenIcon());
        String nodeText = this.getNewNodeText();
        this.setNodeText(StringUtil.isNotEmpty(nodeText) ? nodeText : JamMessages.message("unnamed.element.presentable.name", new Object[0]), null, !this.isValid());
        this.myTooltip = this.getNewTooltip();
    }

    protected P updateElement() {
        return this.myElement;
    }

    @Nullable
    protected abstract String getNewNodeText();

    @Nullable
    protected Icon getNewOpenIcon() {
        return this.myOpenIcon;
    }

    @Nullable
    protected Icon getNewClosedIcon() {
        return this.myClosedIcon;
    }

    protected Color getNewColor() {
        return this.myColor;
    }

    public JamNodeDescriptor[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public Object getData(String dataId) {
        return null;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    @Nullable
    public String getNewTooltip() {
        return this.getNewNodeText();
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Nullable
    protected DeleteProvider getDeleteProvider() {
        return null;
    }

    protected Object getParameters() {
        return this.myParameters;
    }

    @Nullable
    public final Object getDataForElement(String dataId) {
        if ("deleteElementProvider".equals(dataId)) {
            return this.getDeleteProvider();
        }
        return this.getData(dataId);
    }

    public final P getElement() {
        return this.myElement;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean isValid() {
        return true;
    }
}

