/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.LazySimpleTreeBuilder;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class JamAbstractTreeBuilder
extends LazySimpleTreeBuilder {
    public JamAbstractTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, JamNodeDescriptor rootDescriptor) {
        super(tree, treeModel, new JamTreeStructure(rootDescriptor, project), null);
        this.setNodeDescriptorComparator(new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor nodeDescriptor1, NodeDescriptor nodeDescriptor2) {
                int weight2;
                JamNodeDescriptor JamNodeDescriptor1 = (JamNodeDescriptor)nodeDescriptor1;
                JamNodeDescriptor JamNodeDescriptor2 = (JamNodeDescriptor)nodeDescriptor2;
                int weight1 = JamNodeDescriptor1.getWeight();
                if (weight1 != (weight2 = JamNodeDescriptor2.getWeight())) {
                    return weight1 - weight2;
                }
                String s1 = JamNodeDescriptor1.getName();
                String s2 = JamNodeDescriptor2.getName();
                if (s1 == null) {
                    return s2 == null ? 0 : -1;
                }
                if (s2 == null) {
                    return 1;
                }
                return s1.compareToIgnoreCase(s2);
            }
        });
    }

    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return false;
    }

    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return true;
    }

    protected final void expandNodeChildren(DefaultMutableTreeNode node) {
        Object element = ((JamNodeDescriptor)node.getUserObject()).getElement();
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
        super.expandNodeChildren(node);
    }

    public void init() {
        this.initRootNode();
    }

    public boolean addSubtreeToUpdateByElement(Object element) {
        return this.myUpdater.addSubtreeToUpdateByElement(element);
    }

    public void runAfterUpdate(Runnable runnable) {
        this.myUpdater.runAfterUpdate(runnable);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.myRootNode;
    }

    public void updateNode(DefaultMutableTreeNode node) {
        super.updateNode(node);
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor;
    }
}

