/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.ide.wizard.StepListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.CommandButtonGroup;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWizard<T extends Step>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.wizard.AbstractWizard");
    protected int myCurrentStep;
    protected final ArrayList<T> mySteps;
    private JButton myPreviousButton;
    private JButton myNextButton;
    private JButton myFinishButton;
    private JButton myCancelButton;
    private JButton myHelpButton;
    private JPanel myContentPanel;
    private JLabel myIconLabel;
    private Component myCurrentStepComponent;
    private final Map<Component, String> myComponentToIdMap = new HashMap<Component, String>();
    private final StepListener myStepListener = new StepListener(){

        public void stateChanged() {
            AbstractWizard.this.updateStep();
        }
    };

    public AbstractWizard(String title, Component dialogParent) {
        super(dialogParent, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    public AbstractWizard(String title, Project project) {
        super(project, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    private void initWizard(String title) {
        this.setTitle(title);
        this.myCurrentStep = 0;
        this.myPreviousButton = new JButton(IdeBundle.message("button.wizard.previous", new Object[0]));
        this.myNextButton = new JButton(IdeBundle.message("button.wizard.next", new Object[0]));
        this.myFinishButton = new JButton(IdeBundle.message("button.finish", new Object[0]));
        this.myCancelButton = new JButton(CommonBundle.getCancelButtonText());
        this.myHelpButton = new JButton(CommonBundle.getHelpButtonText());
        this.myContentPanel = new JPanel(new CardLayout());
        this.myIconLabel = new JLabel();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.helpAction();
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.helpAction();
            }
        }, KeyStroke.getKeyStroke(156, 0), 2);
    }

    @Override
    protected JComponent createSouthPanel() {
        CommandButtonGroup panel = new CommandButtonGroup();
        panel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        if (this.mySteps.size() > 1) {
            panel.addButton(this.myPreviousButton);
            panel.addButton(this.myNextButton);
        }
        panel.addButton(this.myFinishButton);
        panel.addButton(this.myCancelButton);
        panel.addButton(this.myHelpButton);
        this.myPreviousButton.setEnabled(false);
        this.myPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doPreviousAction();
            }
        });
        this.myNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doNextAction();
            }
        });
        this.myFinishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block2: {
                    Step currentStep = (Step)AbstractWizard.this.mySteps.get(AbstractWizard.this.myCurrentStep);
                    LOG.assertTrue(currentStep != null);
                    try {
                        currentStep._commit(true);
                        AbstractWizard.this.doOKAction();
                    }
                    catch (CommitStepException exc) {
                        String message = exc.getMessage();
                        if (message == null) break block2;
                        Messages.showErrorDialog(AbstractWizard.this.myContentPanel, message);
                    }
                }
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doCancelAction();
            }
        });
        this.myHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.helpAction();
            }
        });
        return panel;
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.myIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myContentPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    public int getCurrentStep() {
        return this.myCurrentStep;
    }

    protected T getCurrentStepObject() {
        return (T)((Step)this.mySteps.get(this.myCurrentStep));
    }

    public void addStep(T step) {
        JComponent component;
        this.mySteps.add(step);
        if (step instanceof StepAdapter) {
            ((StepAdapter)step).registerStepListener(this.myStepListener);
        }
        if ((component = step.getComponent()) != null) {
            this.addStepComponent(component);
        }
        if (this.mySteps.size() > 1) {
            this.myFinishButton.setText(IdeBundle.message("button.finish", new Object[0]));
        } else {
            this.myFinishButton.setText(IdeBundle.message("button.ok", new Object[0]));
        }
    }

    @Override
    protected void init() {
        super.init();
        this.updateStep();
    }

    private String addStepComponent(Component component) {
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = Integer.toString(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add(component, id);
        }
        return id;
    }

    private void showStepComponent(Component component) {
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = this.addStepComponent(component);
            this.myContentPanel.revalidate();
            this.myContentPanel.repaint();
        }
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, id);
    }

    protected void doPreviousAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep();
    }

    protected void doNextAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep();
    }

    protected int getNextStep(int step) {
        int stepCount = this.mySteps.size();
        if (++step >= stepCount) {
            step = stepCount - 1;
        }
        return step;
    }

    protected final int getNextStep() {
        return this.getNextStep(this.getCurrentStep());
    }

    protected T getNextStepObject() {
        int step = this.getNextStep();
        return (T)((Step)this.mySteps.get(step));
    }

    protected int getPreviousStep(int step) {
        if (--step < 0) {
            step = 0;
        }
        return step;
    }

    protected final int getPreviousStep() {
        return this.getPreviousStep(this.getCurrentStep());
    }

    protected void updateStep() {
        if (this.mySteps.size() == 0) {
            return;
        }
        Step step = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(step != null);
        step._init();
        this.myCurrentStepComponent = step.getComponent();
        LOG.assertTrue(this.myCurrentStepComponent != null);
        this.showStepComponent(this.myCurrentStepComponent);
        Icon icon = step.getIcon();
        this.myIconLabel.setIcon(icon);
        if (icon != null) {
            this.myIconLabel.setSize(icon.getIconWidth(), icon.getIconHeight());
        } else {
            this.myIconLabel.setSize(0, 0);
        }
        this.myNextButton.setEnabled(this.mySteps.size() == 1 || this.myCurrentStep < this.mySteps.size() - 1);
        this.myPreviousButton.setEnabled(this.myCurrentStep > 0);
    }

    protected JButton getNextButton() {
        return this.myNextButton;
    }

    protected JButton getPreviousButton() {
        return this.myPreviousButton;
    }

    protected JButton getFinishButton() {
        return this.myFinishButton;
    }

    public Component getCurrentStepComponent() {
        return this.myCurrentStepComponent;
    }

    protected void helpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    @Override
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    protected int getNumberOfSteps() {
        return this.mySteps.size();
    }

    @Nullable
    @NonNls
    protected abstract String getHelpID();

    protected boolean isCurrentStep(T step) {
        return step != null && this.getCurrentStepComponent() == step.getComponent();
    }
}

