/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.util.IconLoader;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Sorter
extends TreeAction {
    public static final Sorter[] EMPTY_ARRAY = new Sorter[0];
    @NonNls
    public static final String ALPHA_SORTER_ID = "ALPHA_COMPARATOR";
    public static final Sorter ALPHA_SORTER = new Sorter(){

        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = this.toString(o1);
                    String s2 = this.toString(o2);
                    return s1.compareToIgnoreCase(s2);
                }

                private String toString(Object object) {
                    if (object instanceof SortableTreeElement) {
                        return ((SortableTreeElement)object).getAlphaSortKey();
                    }
                    if (object instanceof TreeElement) {
                        return ((TreeElement)object).getPresentation().getPresentableText();
                    }
                    if (object instanceof Group) {
                        return ((Group)object).getPresentation().getPresentableText();
                    }
                    return object.toString();
                }
            };
        }

        public String toString() {
            return this.getName();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message("action.sort.alphabetically", new Object[0]), IdeBundle.message("action.sort.alphabetically", new Object[0]), IconLoader.getIcon("/objectBrowser/sorted.png"));
            if (actionPresentationData == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/smartTree/Sorter$1.getPresentation must not return null");
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (Sorter.ALPHA_SORTER_ID == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/smartTree/Sorter$1.getName must not return null");
            }
            return Sorter.ALPHA_SORTER_ID;
        }
    };

    public Comparator getComparator();
}

