/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeState
implements JDOMExternalizable {
    @NonNls
    private static final String PATH = "PATH";
    @NonNls
    private static final String PATH_ELEMENT = "PATH_ELEMENT";
    @NonNls
    private static final String USER_OBJECT = "USER_OBJECT";
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
    }

    public TreeState() {
        this(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.myExpandedPaths.clear();
        List paths = element.getChildren(PATH);
        for (Object path : paths) {
            Element xmlPathElement = (Element)path;
            this.myExpandedPaths.add(TreeState.readPath(xmlPathElement));
        }
    }

    private static List<PathElement> readPath(Element xmlPathElement) throws InvalidDataException {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        List elements = xmlPathElement.getChildren(PATH_ELEMENT);
        for (Object element : elements) {
            Element xmlPathElementElement = (Element)element;
            PathElement pathElement = new PathElement();
            pathElement.readExternal(xmlPathElementElement);
            result.add(pathElement);
        }
        return result;
    }

    public static TreeState createOn(JTree tree, DefaultMutableTreeNode treeNode) {
        return new TreeState(TreeState.createExpandedPaths(tree, treeNode), TreeState.createSelectedPaths(tree, treeNode));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        for (List<PathElement> path : this.myExpandedPaths) {
            Element pathElement = new Element(PATH);
            TreeState.writeExternal(pathElement, path);
            element.addContent(pathElement);
        }
    }

    private static void writeExternal(Element pathXmlElement, List<PathElement> path) throws WriteExternalException {
        for (PathElement aPath : path) {
            Element pathXmlElementElement = new Element(PATH_ELEMENT);
            aPath.writeExternal(pathXmlElementElement);
            pathXmlElement.addContent(pathXmlElementElement);
        }
    }

    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/TreeState.createOn must not be null");
        }
        return new TreeState(TreeState.createPaths(tree), new ArrayList<List<PathElement>>());
    }

    private static List<List<PathElement>> createPaths(JTree tree) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> expandedPaths = TreeUtil.collectExpandedPaths(tree);
        for (TreePath expandedPath : expandedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<List<PathElement>> createExpandedPaths(JTree tree, DefaultMutableTreeNode treeNode) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> expandedPaths = TreeUtil.collectExpandedPaths(tree, new TreePath(treeNode.getPath()));
        for (TreePath expandedPath : expandedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<List<PathElement>> createSelectedPaths(JTree tree, DefaultMutableTreeNode treeNode) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> selectedPaths = TreeUtil.collectSelectedPaths(tree, new TreePath(treeNode.getPath()));
        for (TreePath expandedPath : selectedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<PathElement> createPath(TreePath treePath) {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Object pathComponent = treePath.getPathComponent(i);
            if (pathComponent instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathComponent;
                TreeNode parent = node.getParent();
                Object userObject = node.getUserObject();
                if (userObject instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)userObject;
                    int childIndex = parent != null ? parent.getIndex(node) : 0;
                    result.add(new PathElement(TreeState.getDescriptorKey(nodeDescriptor), TreeState.getDescriptorType(nodeDescriptor), childIndex, nodeDescriptor));
                    continue;
                }
                result.add(new PathElement("", "", 0, userObject));
                continue;
            }
            return null;
        }
        return result;
    }

    private static String getDescriptorKey(NodeDescriptor nodeDescriptor) {
        Object value;
        if (nodeDescriptor instanceof AbstractTreeNode && (value = nodeDescriptor instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)((Object)nodeDescriptor)).getKey() : ((AbstractTreeNode)nodeDescriptor).getValue()) instanceof PsiElement && ((PsiElement)value).isValid()) {
            try {
                return value.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nodeDescriptor.toString();
    }

    private static String getDescriptorType(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getClass().getName();
    }

    public void applyTo(JTree tree) {
        this.applyExpanded(tree, tree.getModel().getRoot());
    }

    private void applyExpanded(JTree tree, Object root) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode nodeRoot = (DefaultMutableTreeNode)root;
        TreeNode[] nodePath = nodeRoot.getPath();
        if (nodePath.length > 0) {
            for (List<PathElement> path : this.myExpandedPaths) {
                TreeState.applyTo(nodePath.length - 1, path, root, tree);
            }
        }
    }

    public void applyTo(JTree tree, DefaultMutableTreeNode node) {
        this.applyExpanded(tree, node);
        if (tree.getSelectionCount() == 0) {
            this.applySelected(tree, node);
        }
    }

    private void applySelected(JTree tree, DefaultMutableTreeNode node) {
        TreeUtil.unselect(tree, node);
        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        for (List<PathElement> pathElements : this.mySelectedPaths) {
            TreeState.applySelectedTo(pathElements, tree.getModel().getRoot(), tree, selectionPaths);
        }
        if (selectionPaths.size() > 1) {
            for (TreePath path : selectionPaths) {
                tree.addSelectionPath(path);
            }
        }
    }

    private static DefaultMutableTreeNode findMatchedChild(DefaultMutableTreeNode parent, PathElement pathElement) {
        DefaultMutableTreeNode childNode;
        Object userObject;
        TreeNode child;
        int j;
        for (j = 0; j < parent.getChildCount(); ++j) {
            child = parent.getChildAt(j);
            if (!(child instanceof DefaultMutableTreeNode) || !pathElement.matchedWithByObject(userObject = (childNode = (DefaultMutableTreeNode)child).getUserObject())) continue;
            return childNode;
        }
        for (j = 0; j < parent.getChildCount(); ++j) {
            NodeDescriptor nodeDescriptor;
            child = parent.getChildAt(j);
            if (!(child instanceof DefaultMutableTreeNode) || !((userObject = (childNode = (DefaultMutableTreeNode)child).getUserObject()) instanceof NodeDescriptor) || !pathElement.matchedWith(nodeDescriptor = (NodeDescriptor)userObject)) continue;
            return childNode;
        }
        if (parent.getChildCount() > 0) {
            int index = pathElement.myItemIndex;
            if (index >= parent.getChildCount()) {
                index = parent.getChildCount() - 1;
            }
            if ((child = parent.getChildAt(index)) instanceof DefaultMutableTreeNode) {
                return (DefaultMutableTreeNode)child;
            }
        }
        return null;
    }

    private static boolean applyTo(int positionInPath, List<PathElement> path, Object root, JTree tree) {
        TreeNode child;
        boolean resultFromChild;
        if (!(root instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        Object userObject = treeNode.getUserObject();
        PathElement pathElement = path.get(positionInPath);
        if (userObject instanceof NodeDescriptor ? !pathElement.matchedWith((NodeDescriptor)userObject) : !pathElement.matchedWithByObject(userObject)) {
            return false;
        }
        TreePath currentPath = new TreePath(treeNode.getPath());
        if (!tree.isExpanded(currentPath)) {
            tree.expandPath(currentPath);
        }
        if (positionInPath == path.size() - 1) {
            return true;
        }
        for (int j = 0; j < treeNode.getChildCount() && !(resultFromChild = TreeState.applyTo(positionInPath + 1, path, child = treeNode.getChildAt(j), tree)); ++j) {
        }
        return true;
    }

    private static void applySelectedTo(List<PathElement> path, Object root, JTree tree, List<TreePath> outSelectionPaths) {
        for (int i = 1; i < path.size(); ++i) {
            if (!(root instanceof DefaultMutableTreeNode)) {
                return;
            }
            root = TreeState.findMatchedChild((DefaultMutableTreeNode)root, path.get(i));
        }
        if (!(root instanceof DefaultMutableTreeNode)) {
            return;
        }
        TreePath pathInNewTree = new TreePath(((DefaultMutableTreeNode)root).getPath());
        TreeUtil.selectPath(tree, pathInNewTree);
        outSelectionPaths.add(pathInNewTree);
    }

    static class PathElement
    implements JDOMExternalizable {
        public String myItemId;
        public String myItemType;
        private final int myItemIndex;
        private Object myUserObject;

        public PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.myItemId = itemId;
            this.myItemType = itemType;
            this.myItemIndex = itemIndex;
            this.myUserObject = userObject;
        }

        public PathElement() {
            this.myItemIndex = -1;
            this.myUserObject = null;
        }

        public boolean matchedWith(NodeDescriptor nodeDescriptor) {
            return Comparing.equal(this.myItemId, TreeState.getDescriptorKey(nodeDescriptor)) && Comparing.equal(this.myItemType, TreeState.getDescriptorType(nodeDescriptor));
        }

        public boolean matchedWithByObject(Object object) {
            return this.myUserObject != null && this.myUserObject.equals(object);
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
            this.myUserObject = element.getAttributeValue(TreeState.USER_OBJECT);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
            if (this.myUserObject instanceof String) {
                element.setAttribute(TreeState.USER_OBJECT, (String)this.myUserObject);
            }
        }
    }
}

