/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class NodeRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object userObject;
        Object valueToGetText;
        String text;
        DefaultMutableTreeNode node2;
        Object userObject2;
        Color color = null;
        if (value instanceof DefaultMutableTreeNode && (userObject2 = (node2 = (DefaultMutableTreeNode)value).getUserObject()) instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)userObject2;
            color = descriptor.getColor();
            if (expanded) {
                this.setIcon(descriptor.getOpenIcon());
            } else {
                this.setIcon(descriptor.getClosedIcon());
            }
        }
        if ((text = tree.convertValueToText(valueToGetText = value instanceof AbstractTreeNode ? value.toString() : value, selected, expanded, leaf, row, hasFocus)) == null) {
            text = "";
        }
        SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes(value, color);
        this.append(text, simpleTextAttributes);
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)userObject;
            String locationString = treeNode.getPresentation().getLocationString();
            if (locationString != null && locationString.length() > 0) {
                this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            this.setToolTipText(treeNode.getToolTip());
        }
    }

    protected static SimpleTextAttributes getSimpleTextAttributes(Object value, Color color) {
        Object userObject;
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof AbstractTreeNode) {
            simpleTextAttributes = NodeRenderer.getSimpleTextAttributes(((AbstractTreeNode)userObject).getPresentation());
        }
        if (color != null) {
            TextAttributes textAttributes = simpleTextAttributes.toTextAttributes();
            textAttributes.setForegroundColor(color);
            simpleTextAttributes = SimpleTextAttributes.fromTextAttributes(textAttributes);
        }
        return simpleTextAttributes;
    }

    public static SimpleTextAttributes getSimpleTextAttributes(ItemPresentation presentation) {
        TextAttributesKey textAttributesKey = presentation.getTextAttributesKey();
        if (textAttributesKey == null) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributesKey);
        return textAttributes == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.fromTextAttributes(textAttributes);
    }
}

