/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class AbstractTreeUpdater
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.treeView.AbstractTreeUpdater");
    private final LinkedList<DefaultMutableTreeNode> myNodesToUpdate = new LinkedList();
    private final AbstractTreeBuilder myTreeBuilder;
    private Runnable myRunAfterUpdate;
    private Runnable myRunBeforeUpdate;
    private final MergingUpdateQueue myUpdateQueue;

    public AbstractTreeUpdater(AbstractTreeBuilder treeBuilder) {
        this.myTreeBuilder = treeBuilder;
        JTree tree = this.myTreeBuilder.getTree();
        this.myUpdateQueue = new MergingUpdateQueue("UpdateQueue", 300, tree.isShowing(), tree);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector(tree, this.myUpdateQueue);
        Disposer.register(this, this.myUpdateQueue);
        Disposer.register(this, uiNotifyConnector);
    }

    public void setDelay(int delay) {
        this.myUpdateQueue.setMergingTimeSpan(delay);
    }

    public void dispose() {
    }

    public synchronized void addSubtreeToUpdate(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUpdater.addSubtreeToUpdate must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSubtreeToUpdate:" + rootNode);
        }
        Iterator iterator = this.myNodesToUpdate.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)iterator.next();
            if (rootNode.isNodeAncestor(node)) {
                return;
            }
            if (!node.isNodeAncestor(rootNode)) continue;
            iterator.remove();
        }
        this.myNodesToUpdate.add(rootNode);
        this.myUpdateQueue.queue(new Update("ViewUpdate"){

            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            public void run() {
                if (AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure().hasSomethingToCommit()) {
                    AbstractTreeUpdater.this.myUpdateQueue.queue(this);
                    return;
                }
                AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure().commit();
                try {
                    AbstractTreeUpdater.this.performUpdate();
                }
                catch (RuntimeException e) {
                    LOG.error(AbstractTreeUpdater.this.myTreeBuilder.getClass().getName(), e);
                }
            }
        });
    }

    protected void updateSubtree(DefaultMutableTreeNode node) {
        this.myTreeBuilder.updateSubtree(node);
    }

    public synchronized void performUpdate() {
        if (this.myRunBeforeUpdate != null) {
            this.myRunBeforeUpdate.run();
            this.myRunBeforeUpdate = null;
        }
        while (!this.myNodesToUpdate.isEmpty()) {
            DefaultMutableTreeNode node = this.myNodesToUpdate.removeFirst();
            this.updateSubtree(node);
        }
        if (this.myRunAfterUpdate != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AbstractTreeUpdater abstractTreeUpdater = AbstractTreeUpdater.this;
                    synchronized (abstractTreeUpdater) {
                        if (AbstractTreeUpdater.this.myRunAfterUpdate != null) {
                            AbstractTreeUpdater.this.myRunAfterUpdate.run();
                            AbstractTreeUpdater.this.myRunAfterUpdate = null;
                        }
                    }
                }
            });
        }
    }

    public boolean addSubtreeToUpdateByElement(Object element) {
        DefaultMutableTreeNode node;
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSubtreeToUpdateByElement:" + element);
        }
        if ((node = this.myTreeBuilder.getNodeForElement(element)) != null) {
            this.addSubtreeToUpdate(node);
            return true;
        }
        return false;
    }

    public void cancelAllRequests() {
        this.myNodesToUpdate.clear();
        this.myUpdateQueue.cancelAllUpdates();
    }

    public synchronized void runAfterUpdate(Runnable runnable) {
        this.myRunAfterUpdate = runnable;
    }

    public synchronized void runBeforeUpdate(Runnable runnable) {
        this.myRunBeforeUpdate = runnable;
    }
}

