/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode<T>
extends NodeDescriptor
implements NavigationItem {
    private AbstractTreeNode myParent;
    private T myValue;
    private NodeDescriptor myParentDescriptor;
    protected String myLocationString;
    private TextAttributesKey myAttributesKey;
    private String myTooltip;

    protected AbstractTreeNode(Project project, T value) {
        super(project, null);
        this.setValue(value);
    }

    @NotNull
    public abstract Collection<? extends AbstractTreeNode> getChildren();

    @Override
    public final boolean update() {
        PresentationData presentation = this.getUpdatedData();
        Icon openIcon = presentation.getIcon(true);
        Icon closedIcon = presentation.getIcon(false);
        String name = presentation.getPresentableText();
        String locationString = presentation.getLocationString();
        TextAttributesKey attributesKey = presentation.getTextAttributesKey();
        Color color = this.computeColor();
        String tooltip = presentation.getTooltip();
        boolean updated = !Comparing.equal(new Object[]{this.myOpenIcon, this.myClosedIcon, this.myName, this.myLocationString, this.myColor, this.myAttributesKey, this.myTooltip}, new Object[]{openIcon, closedIcon, name, locationString, color, attributesKey, tooltip});
        this.myOpenIcon = openIcon;
        this.myClosedIcon = closedIcon;
        this.myName = name;
        this.myLocationString = locationString;
        this.myColor = color;
        this.myAttributesKey = attributesKey;
        this.myTooltip = tooltip;
        return updated;
    }

    private Color computeColor() {
        Color color = this.getFileStatus().getColor();
        if (this.valueIsCut()) {
            color = CopyPasteManager.CUT_COLOR;
        }
        return color;
    }

    protected boolean hasProblemFileBeneath() {
        return false;
    }

    protected boolean valueIsCut() {
        return CopyPasteManager.getInstance().isCutElement(this.getValue());
    }

    private PresentationData getUpdatedData() {
        PresentationData presentation = new PresentationData();
        if (this.shouldUpdateData()) {
            this.update(presentation);
        }
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
        }
        return presentation;
    }

    protected boolean shouldUpdateData() {
        return !this.myProject.isDisposed() && this.getValue() != null;
    }

    protected abstract void update(PresentationData var1);

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return false;
    }

    @Nullable
    public final Object getElement() {
        return this.getValue() != null ? this : null;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTreeNode && Comparing.equal(this.getValue(), ((AbstractTreeNode)object).getValue());
    }

    public int hashCode() {
        return this.getValue() == null ? 0 : this.getValue().hashCode();
    }

    public final AbstractTreeNode getParent() {
        return this.myParent;
    }

    public final void setParent(AbstractTreeNode parent) {
        this.myParent = parent;
        this.myParentDescriptor = parent;
    }

    public final AbstractTreeNode setParentDescriptor(NodeDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
        return this;
    }

    @Override
    public final NodeDescriptor getParentDescriptor() {
        return this.myParentDescriptor;
    }

    public final T getValue() {
        return this.myValue;
    }

    public final void setValue(T value) {
        this.myValue = value;
    }

    @Nullable
    @NonNls
    public String getTestPresentation() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PresentationData(this.myName, this.myLocationString, this.myOpenIcon, this.myClosedIcon, this.myAttributesKey);
    }

    @Override
    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void navigate(boolean requestFocus) {
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    protected final Object getParentValue() {
        AbstractTreeNode parent = this.getParent();
        return parent == null ? null : parent.getValue();
    }

    protected String getToolTip() {
        return this.myTooltip;
    }

    public boolean canRepresent(Object element) {
        return Comparing.equal(this.getValue(), element);
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    public String getLocationString() {
        return this.myLocationString;
    }
}

