/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.WorkerThread;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakList;
import com.intellij.util.enumeration.EnumerationCopy;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeBuilder
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.treeView.AbstractTreeBuilder");
    protected final JTree myTree;
    protected final DefaultTreeModel myTreeModel;
    protected AbstractTreeStructure myTreeStructure;
    protected final AbstractTreeUpdater myUpdater;
    private Comparator<NodeDescriptor> myNodeDescriptorComparator;
    private final Comparator<TreeNode> myNodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode n1, TreeNode n2) {
            if (AbstractTreeBuilder.isLoadingNode(n1) || AbstractTreeBuilder.isLoadingNode(n2)) {
                return 0;
            }
            NodeDescriptor nodeDescriptor1 = (NodeDescriptor)((DefaultMutableTreeNode)n1).getUserObject();
            NodeDescriptor nodeDescriptor2 = (NodeDescriptor)((DefaultMutableTreeNode)n2).getUserObject();
            return AbstractTreeBuilder.this.myNodeDescriptorComparator != null ? AbstractTreeBuilder.this.myNodeDescriptorComparator.compare(nodeDescriptor1, nodeDescriptor2) : nodeDescriptor1.getIndex() - nodeDescriptor2.getIndex();
        }
    };
    protected final DefaultMutableTreeNode myRootNode;
    private final HashMap<Object, Object> myElementToNodeMap = new HashMap();
    private final HashSet<DefaultMutableTreeNode> myUnbuiltNodes = new HashSet();
    private final TreeExpansionListener myExpansionListener;
    private WorkerThread myWorker = null;
    private final ProgressIndicator myProgress;
    private static final int WAIT_CURSOR_DELAY = 100;
    private boolean myDisposed = false;
    private final AbstractTreeNode<Object> TREE_NODE_WRAPPER = this.createSearchingTreeNodeWrapper();
    private boolean myRootNodeWasInitialized = false;
    private final Map<Object, List<NodeAction>> myBackgroundableNodeActions = new HashMap<Object, List<NodeAction>>();
    private boolean myUpdateFromRootRequested;
    private boolean myWasEverShown;
    private final boolean myUpdateIfInactive;
    private WeakList<Object> myLoadingParents = new WeakList();
    private final List<Runnable> myDeferredSelections = new ArrayList<Runnable>();

    protected AbstractTreeNode createSearchingTreeNodeWrapper() {
        return new AbstractTreeNodeWrapper();
    }

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator) {
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        this.myTree = tree;
        this.myTreeModel = treeModel;
        this.myRootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        this.myTreeStructure = treeStructure;
        this.myNodeDescriptorComparator = comparator;
        this.myUpdateIfInactive = updateIfInactive;
        this.myExpansionListener = new MyExpansionListener();
        this.myTree.addTreeExpansionListener(this.myExpansionListener);
        this.myUpdater = this.createUpdater();
        this.myProgress = this.createProgressIndicator();
        Disposer.register(this, this.myUpdater);
        new UiNotifyConnector(tree, new Activatable(){

            public void showNotify() {
                if (AbstractTreeBuilder.this.myWasEverShown && AbstractTreeBuilder.this.myUpdateFromRootRequested) {
                    AbstractTreeBuilder.this.updateFromRoot();
                }
                AbstractTreeBuilder.this.myWasEverShown = true;
            }

            public void hideNotify() {
                if (!AbstractTreeBuilder.this.myWasEverShown) {
                    return;
                }
                if (!AbstractTreeBuilder.this.myBackgroundableNodeActions.isEmpty()) {
                    AbstractTreeBuilder.this.cancelBackgroundLoading();
                    AbstractTreeBuilder.this.myUpdateFromRootRequested = true;
                }
            }
        });
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getElement();
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected AbstractTreeUpdater createUpdater() {
        return new AbstractTreeUpdater(this);
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myTree.removeTreeExpansionListener(this.myExpansionListener);
        this.disposeNode(this.myRootNode);
        this.myElementToNodeMap.clear();
        this.myUpdater.cancelAllRequests();
        this.myUpdater.dispose();
        if (this.myWorker != null) {
            this.myWorker.dispose(true);
        }
        this.myElementToNodeMap.clear();
        this.TREE_NODE_WRAPPER.setValue(null);
        if (this.myProgress != null) {
            this.myProgress.cancel();
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected abstract boolean isAlwaysShowPlus(NodeDescriptor var1);

    protected abstract boolean isAutoExpandNode(NodeDescriptor var1);

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    protected void expandNodeChildren(DefaultMutableTreeNode node) {
        this.myTreeStructure.commit();
        this.myUpdater.addSubtreeToUpdate(node);
        this.addNodeAction(AbstractTreeBuilder.getElementFor(node), new NodeAction(){

            public void onReady(DefaultMutableTreeNode node) {
                AbstractTreeBuilder.this.processSmartExpand(node);
            }
        });
        this.myUpdater.performUpdate();
    }

    public final AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public final JTree getTree() {
        return this.myTree;
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForElement(Object element) {
        DefaultMutableTreeNode node = this.getFirstNode(element);
        if (node != null) {
            LOG.assertTrue(TreeUtil.isAncestor(this.myRootNode, node));
            LOG.assertTrue(this.myRootNode == this.myTreeModel.getRoot());
        }
        return node;
    }

    public final DefaultMutableTreeNode getNodeForPath(Object[] path) {
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null) break;
        }
        return node;
    }

    public final void buildNodeForElement(Object element) {
        this.myUpdater.performUpdate();
        DefaultMutableTreeNode node = this.getNodeForElement(element);
        if (node == null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            while ((element = this.myTreeStructure.getParentElement(element)) != null) {
                elements.add(0, element);
            }
            for (Object e : elements) {
                node = this.getNodeForElement(e);
                if (node == null) continue;
                this.expand(node);
            }
        }
    }

    public final void buildNodeForPath(Object[] path) {
        this.myUpdater.performUpdate();
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null) continue;
            this.expand(node);
        }
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        this.myNodeDescriptorComparator = nodeDescriptorComparator;
        ArrayList<Object> pathsToExpand = new ArrayList<Object>();
        ArrayList<Object> selectionPaths = new ArrayList<Object>();
        TreeBuilderUtil.storePaths(this, this.myRootNode, pathsToExpand, selectionPaths, false);
        this.resortChildren(this.myRootNode);
        this.myTreeModel.nodeStructureChanged(this.myRootNode);
        TreeBuilderUtil.restorePaths(this, pathsToExpand, selectionPaths, false);
    }

    private void resortChildren(DefaultMutableTreeNode node) {
        ArrayList<TreeNode> childNodes = TreeUtil.childrenToArray(node);
        node.removeAllChildren();
        Collections.sort(childNodes, this.myNodeComparator);
        for (TreeNode childNode1 : childNodes) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
            node.add(childNode);
            this.resortChildren(childNode);
        }
    }

    protected final void initRootNode() {
        Activatable activatable = new Activatable(){

            public void showNotify() {
                if (!AbstractTreeBuilder.this.myRootNodeWasInitialized) {
                    AbstractTreeBuilder.this.initRootNodeNow();
                }
            }

            public void hideNotify() {
            }
        };
        if (this.myUpdateIfInactive || ApplicationManager.getApplication().isUnitTestMode()) {
            activatable.showNotify();
        } else {
            new UiNotifyConnector.Once(this.myTree, activatable);
        }
    }

    private void initRootNodeNow() {
        if (this.myRootNodeWasInitialized) {
            return;
        }
        this.myRootNodeWasInitialized = true;
        Object rootElement = this.myTreeStructure.getRootElement();
        this.addNodeAction(rootElement, new NodeAction(){

            public void onReady(DefaultMutableTreeNode node) {
                Runnable[] runnables = AbstractTreeBuilder.this.myDeferredSelections.toArray(new Runnable[AbstractTreeBuilder.this.myDeferredSelections.size()]);
                AbstractTreeBuilder.this.myDeferredSelections.clear();
                for (Runnable runnable : runnables) {
                    runnable.run();
                }
            }
        });
        NodeDescriptor nodeDescriptor = this.myTreeStructure.createDescriptor(rootElement, null);
        this.myRootNode.setUserObject(nodeDescriptor);
        this.updateNodeDescriptor(nodeDescriptor);
        if (nodeDescriptor.getElement() != null) {
            this.createMapping(nodeDescriptor.getElement(), this.myRootNode);
        }
        this.addLoadingNode(this.myRootNode);
        boolean willUpdate = false;
        if (this.isAutoExpandNode(nodeDescriptor)) {
            willUpdate = this.myUnbuiltNodes.contains(this.myRootNode);
            this.expand(this.myRootNode);
        }
        if (!willUpdate) {
            this.updateNodeChildren(this.myRootNode);
        }
        if (this.myRootNode.getChildCount() == 0) {
            this.myTreeModel.nodeChanged(this.myRootNode);
        }
    }

    public void updateFromRoot() {
        this.updateSubtree(this.myRootNode);
    }

    public final void updateSubtree(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        TreeState treeState = TreeState.createOn(this.myTree, node);
        this.updateNode(node);
        this.updateNodeChildren(node);
        treeState.applyTo(this.myTree, node);
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        Object prevElement = descriptor.getElement();
        if (prevElement == null) {
            return;
        }
        boolean changes = this.updateNodeDescriptor(descriptor);
        if (descriptor.getElement() == null) {
            LOG.assertTrue(false, "element == null, updateSubtree should be invoked for parent! builder=" + this + ", prevElement = " + prevElement + ", node = " + node + "; parentDescriptor=" + descriptor.getParentDescriptor());
        }
        if (changes) {
            this.updateNodeImageAndPosition(node);
        }
    }

    private void updateNodeChildren(DefaultMutableTreeNode node) {
        this.myTreeStructure.commit();
        boolean wasExpanded = this.myTree.isExpanded(new TreePath(node.getPath()));
        boolean wasLeaf = node.getChildCount() == 0;
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        if (descriptor == null) {
            return;
        }
        if (this.myUnbuiltNodes.contains(node)) {
            this.processUnbuilt(node, descriptor);
            return;
        }
        if (this.myTreeStructure.isToBuildChildrenInBackground(this.getTreeStructureElement(descriptor)) && this.queueBackgroundUpdate(node, descriptor)) {
            return;
        }
        Map<Object, Integer> elementToIndexMap = this.collectElementToIndexMap(descriptor);
        this.processAllChildren(node, elementToIndexMap);
        ArrayList<TreeNode> nodesToInsert = this.collectNodesToInsert(descriptor, elementToIndexMap);
        this.insertNodesInto(nodesToInsert, node);
        this.updateNodesToInsert(nodesToInsert);
        if (wasExpanded) {
            this.expand(node);
        }
        if (wasExpanded || wasLeaf) {
            this.expand(node, descriptor, wasLeaf);
        }
        this.processNodeActionsIfReady(node);
    }

    private void expand(DefaultMutableTreeNode node) {
        this.expand(new TreePath(node.getPath()));
    }

    private void expand(TreePath path) {
        if (path == null) {
            return;
        }
        boolean isLeaf = this.myTree.getModel().isLeaf(path.getLastPathComponent());
        TreePath parent = path.getParentPath();
        if (this.myTree.isExpanded(path) || isLeaf && parent != null && this.myTree.isExpanded(parent)) {
            Object last = path.getLastPathComponent();
            if (last instanceof DefaultMutableTreeNode) {
                this.processNodeActionsIfReady((DefaultMutableTreeNode)last);
            }
        } else {
            this.myTree.expandPath(path);
        }
    }

    private void processUnbuilt(DefaultMutableTreeNode node, NodeDescriptor descriptor) {
        if (this.isAlwaysShowPlus(descriptor)) {
            return;
        }
        if (this.myTreeStructure.isToBuildChildrenInBackground(this.getTreeStructureElement(descriptor))) {
            return;
        }
        Object[] children = this.myTreeStructure.getChildElements(this.getTreeStructureElement(descriptor));
        if (children.length == 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!AbstractTreeBuilder.isLoadingNode(node.getChildAt(i))) continue;
                this.myTreeModel.removeNodeFromParent((MutableTreeNode)node.getChildAt(i));
                break;
            }
            this.myUnbuiltNodes.remove(node);
        }
    }

    private void updateNodesToInsert(ArrayList<TreeNode> nodesToInsert) {
        for (TreeNode aNodesToInsert : nodesToInsert) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)aNodesToInsert;
            this.addLoadingNode(childNode);
            this.updateNodeChildren(childNode);
        }
    }

    private void processAllChildren(DefaultMutableTreeNode node, Map<Object, Integer> elementToIndexMap) {
        ArrayList<TreeNode> childNodes = TreeUtil.childrenToArray(node);
        for (TreeNode childNode1 : childNodes) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
            if (AbstractTreeBuilder.isLoadingNode(childNode)) continue;
            this.processChildNode(childNode, (NodeDescriptor)childNode.getUserObject(), node, elementToIndexMap);
        }
    }

    private Map<Object, Integer> collectElementToIndexMap(NodeDescriptor descriptor) {
        LinkedHashMap<Object, Integer> elementToIndexMap = new LinkedHashMap<Object, Integer>();
        Object[] children = this.myTreeStructure.getChildElements(this.getTreeStructureElement(descriptor));
        int index = 0;
        for (Object child : children) {
            if (child instanceof ProjectViewNode) {
                ProjectViewNode projectViewNode = (ProjectViewNode)child;
                this.updateNodeDescriptor(projectViewNode);
                if (projectViewNode.getValue() == null) continue;
            }
            elementToIndexMap.put(child, index);
            ++index;
        }
        return elementToIndexMap;
    }

    private void expand(DefaultMutableTreeNode node, NodeDescriptor descriptor, boolean wasLeaf) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        alarm.addRequest(new Runnable(){

            public void run() {
                AbstractTreeBuilder.this.myTree.setCursor(Cursor.getPredefinedCursor(3));
            }
        }, 100);
        if (wasLeaf && this.isAutoExpandNode(descriptor)) {
            this.expand(node);
        }
        ArrayList<TreeNode> nodes = TreeUtil.childrenToArray(node);
        for (TreeNode node1 : nodes) {
            NodeDescriptor childDescr;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node1;
            if (AbstractTreeBuilder.isLoadingNode(childNode) || !this.isAutoExpandNode(childDescr = (NodeDescriptor)childNode.getUserObject())) continue;
            this.expand(childNode);
        }
        int n = alarm.cancelAllRequests();
        if (n == 0) {
            this.myTree.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static boolean isLoadingNode(Object node) {
        return node instanceof LoadingNode;
    }

    private ArrayList<TreeNode> collectNodesToInsert(NodeDescriptor descriptor, Map<Object, Integer> elementToIndexMap) {
        ArrayList<TreeNode> nodesToInsert = new ArrayList<TreeNode>();
        for (Map.Entry<Object, Integer> entry : elementToIndexMap.entrySet()) {
            Object child = entry.getKey();
            Integer index = entry.getValue();
            NodeDescriptor childDescr = this.myTreeStructure.createDescriptor(child, descriptor);
            if (childDescr == null) {
                LOG.error("childDescr == null, treeStructure = " + this.myTreeStructure + ", child = " + child);
                continue;
            }
            childDescr.setIndex(index);
            this.updateNodeDescriptor(childDescr);
            if (childDescr.getElement() == null) {
                LOG.error("childDescr.getElement() == null, child = " + child + ", builder = " + this);
                continue;
            }
            DefaultMutableTreeNode childNode = this.createChildNode(childDescr);
            nodesToInsert.add(childNode);
            this.createMapping(childDescr.getElement(), childNode);
        }
        return nodesToInsert;
    }

    protected DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new DefaultMutableTreeNode(childDescr);
    }

    private boolean queueBackgroundUpdate(final DefaultMutableTreeNode node, final NodeDescriptor descriptor) {
        if (this.isLoadingChildrenFor(node)) {
            return false;
        }
        LoadingNode loadingNode = new LoadingNode(this.getLoadingNodeText());
        this.myTreeModel.insertNodeInto(loadingNode, node, node.getChildCount());
        this.myLoadingParents.add(descriptor.getElement());
        Runnable updateRunnable = new Runnable(){

            public void run() {
                AbstractTreeBuilder.this.updateNodeDescriptor(descriptor);
                Object element = descriptor.getElement();
                if (element == null) {
                    return;
                }
                AbstractTreeBuilder.this.myTreeStructure.getChildElements(AbstractTreeBuilder.this.getTreeStructureElement(descriptor));
            }
        };
        Runnable postRunnable = new Runnable(){

            public void run() {
                AbstractTreeBuilder.this.myLoadingParents.remove(descriptor.getElement());
                AbstractTreeBuilder.this.updateNodeDescriptor(descriptor);
                Object element = descriptor.getElement();
                if (element != null) {
                    AbstractTreeBuilder.this.myUnbuiltNodes.remove(node);
                    AbstractTreeBuilder.this.myUpdater.addSubtreeToUpdateByElement(element);
                    AbstractTreeBuilder.this.myUpdater.performUpdate();
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!AbstractTreeBuilder.isLoadingNode(child)) continue;
                        if (TreeBuilderUtil.isNodeSelected(AbstractTreeBuilder.this.myTree, node)) {
                            AbstractTreeBuilder.this.myTree.addSelectionPath(new TreePath(AbstractTreeBuilder.this.myTreeModel.getPathToRoot(node)));
                        }
                        AbstractTreeBuilder.this.myTreeModel.removeNodeFromParent((MutableTreeNode)child);
                        break;
                    }
                    AbstractTreeBuilder.this.processNodeActionsIfReady(node);
                }
            }
        };
        this.addTaskToWorker(updateRunnable, true, postRunnable);
        return true;
    }

    private void processNodeActionsIfReady(DefaultMutableTreeNode node) {
        if (this.isNodeBeingBuilt(node)) {
            return;
        }
        Object o = node.getUserObject();
        if (!(o instanceof NodeDescriptor)) {
            return;
        }
        Object element = ((NodeDescriptor)o).getElement();
        List<NodeAction> actions = this.myBackgroundableNodeActions.get(element);
        if (actions != null) {
            this.myBackgroundableNodeActions.remove(element);
            for (NodeAction each : actions) {
                each.onReady(node);
            }
        }
    }

    private void processSmartExpand(DefaultMutableTreeNode node) {
        if (this.isSmartExpand() && node.getChildCount() == 1) {
            TreeNode childNode = node.getChildAt(0);
            if (AbstractTreeBuilder.isLoadingNode(childNode)) {
                return;
            }
            TreePath childPath = new TreePath(node.getPath()).pathByAddingChild(childNode);
            this.expand(childPath);
        }
    }

    private boolean isLoadingChildrenFor(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        boolean areChuldrenLoading = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!AbstractTreeBuilder.isLoadingNode(child) || !this.getLoadingNodeText().equals(((LoadingNode)child).getUserObject())) continue;
            areChuldrenLoading = true;
        }
        return areChuldrenLoading;
    }

    private boolean isParentLoading(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        TreeNode eachParent = node.getParent();
        while (eachParent != null) {
            Object eachElement;
            if (!((eachParent = eachParent.getParent()) instanceof DefaultMutableTreeNode) || !this.myLoadingParents.contains(eachElement = AbstractTreeBuilder.getElementFor((DefaultMutableTreeNode)eachParent))) continue;
            return true;
        }
        return false;
    }

    protected String getLoadingNodeText() {
        return IdeBundle.message("progress.searching", new Object[0]);
    }

    private void processChildNode(DefaultMutableTreeNode childNode, NodeDescriptor childDescr, DefaultMutableTreeNode node, Map<Object, Integer> elementToIndexMap) {
        Integer index;
        if (childDescr == null) {
            boolean isInMap = this.myElementToNodeMap.containsValue(childNode);
            LOG.error("childDescr == null, builder=" + this + ", childNode=" + childNode.getClass() + ", isInMap = " + isInMap + ", node = " + node);
            return;
        }
        Object oldElement = childDescr.getElement();
        if (oldElement == null) {
            LOG.error("oldElement == null, builder=" + this + ", childDescr=" + childDescr);
            return;
        }
        boolean changes = this.updateNodeDescriptor(childDescr);
        Object newElement = childDescr.getElement();
        Integer n = index = newElement != null ? elementToIndexMap.get(this.getTreeStructureElement(childDescr)) : null;
        if (index != null) {
            if (childDescr.getIndex() != index.intValue()) {
                changes = true;
            }
            childDescr.setIndex(index);
        }
        if (index != null && changes) {
            this.updateNodeImageAndPosition(childNode);
        }
        if (!oldElement.equals(newElement)) {
            this.removeMapping(oldElement, childNode);
            if (newElement != null) {
                this.createMapping(newElement, childNode);
            }
        }
        if (index == null) {
            int selectedIndex = -1;
            if (TreeBuilderUtil.isNodeOrChildSelected(this.myTree, childNode)) {
                selectedIndex = node.getIndex(childNode);
            }
            this.myTreeModel.removeNodeFromParent(childNode);
            this.disposeNode(childNode);
            if (selectedIndex >= 0) {
                if (node.getChildCount() > 0) {
                    if (node.getChildCount() > selectedIndex) {
                        TreeNode newChildNode = node.getChildAt(selectedIndex);
                        this.myTree.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChildNode)));
                    } else {
                        TreeNode newChild = node.getChildAt(node.getChildCount() - 1);
                        this.myTree.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChild)));
                    }
                } else {
                    this.myTree.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(node)));
                }
            }
        } else {
            elementToIndexMap.remove(this.getTreeStructureElement(childDescr));
            this.updateNodeChildren(childNode);
        }
        if (node.equals(this.myRootNode)) {
            this.myTreeModel.nodeChanged(this.myRootNode);
        }
    }

    protected boolean updateNodeDescriptor(NodeDescriptor descriptor) {
        return descriptor.update();
    }

    private void addLoadingNode(DefaultMutableTreeNode node) {
        final NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        if (!this.isAlwaysShowPlus(descriptor)) {
            if (this.myTreeStructure.isToBuildChildrenInBackground(this.getTreeStructureElement(descriptor))) {
                final boolean[] hasNoChildren = new boolean[1];
                Runnable runnable = new Runnable(){

                    public void run() {
                        AbstractTreeBuilder.this.updateNodeDescriptor(descriptor);
                        Object element = AbstractTreeBuilder.this.getTreeStructureElement(descriptor);
                        if (element == null) {
                            return;
                        }
                        Object[] children = AbstractTreeBuilder.this.myTreeStructure.getChildElements(element);
                        hasNoChildren[0] = children.length == 0;
                    }
                };
                Runnable postRunnable = new Runnable(){

                    public void run() {
                        if (hasNoChildren[0]) {
                            DefaultMutableTreeNode node;
                            AbstractTreeBuilder.this.updateNodeDescriptor(descriptor);
                            Object element = descriptor.getElement();
                            if (element != null && (node = AbstractTreeBuilder.this.getNodeForElement(element)) != null) {
                                AbstractTreeBuilder.this.expand(node);
                            }
                        }
                    }
                };
                this.addTaskToWorker(runnable, false, postRunnable);
            } else {
                Object[] children = this.myTreeStructure.getChildElements(this.getTreeStructureElement(descriptor));
                if (children.length == 0) {
                    return;
                }
            }
        }
        this.myTreeModel.insertNodeInto(new LoadingNode(), node, 0);
        this.myUnbuiltNodes.add(node);
    }

    protected void addTaskToWorker(final Runnable runnable, boolean first, final Runnable postRunnable) {
        Runnable runnable1 = new Runnable(){

            public void run() {
                try {
                    Runnable runnable2 = new Runnable(){

                        public void run() {
                            ApplicationManager.getApplication().runReadAction(runnable);
                            if (postRunnable != null) {
                                ApplicationManager.getApplication().invokeLater(postRunnable, ModalityState.stateForComponent(AbstractTreeBuilder.this.myTree));
                            }
                        }
                    };
                    if (AbstractTreeBuilder.this.myProgress != null) {
                        ProgressManager.getInstance().runProcess(runnable2, AbstractTreeBuilder.this.myProgress);
                    } else {
                        runnable2.run();
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        };
        if (this.myWorker == null || this.myWorker.isDisposed()) {
            this.myWorker = new WorkerThread("AbstractTreeBuilder.Worker", 1);
            this.myWorker.start();
            if (first) {
                this.myWorker.addTaskFirst(runnable1);
            } else {
                this.myWorker.addTask(runnable1);
            }
            this.myWorker.dispose(false);
        } else if (first) {
            this.myWorker.addTaskFirst(runnable1);
        } else {
            this.myWorker.addTask(runnable1);
        }
    }

    private void updateNodeImageAndPosition(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        if (descriptor.getElement() == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (parentNode != null) {
            int oldIndex = parentNode.getIndex(node);
            int newIndex = 0;
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                if (node == node1 || node1.getUserObject() instanceof NodeDescriptor && ((NodeDescriptor)node1.getUserObject()).getElement() == null || this.myNodeComparator.compare(node, node1) <= 0) continue;
                ++newIndex;
            }
            if (oldIndex != newIndex) {
                ArrayList<Object> pathsToExpand = new ArrayList<Object>();
                ArrayList<Object> selectionPaths = new ArrayList<Object>();
                TreeBuilderUtil.storePaths(this, node, pathsToExpand, selectionPaths, false);
                this.myTreeModel.removeNodeFromParent(node);
                this.myTreeModel.insertNodeInto(node, parentNode, newIndex);
                TreeBuilderUtil.restorePaths(this, pathsToExpand, selectionPaths, false);
            } else {
                this.myTreeModel.nodeChanged(node);
            }
        } else {
            this.myTreeModel.nodeChanged(node);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    private void insertNodesInto(ArrayList<TreeNode> nodes, DefaultMutableTreeNode parentNode) {
        if (nodes.isEmpty()) {
            return;
        }
        nodes = new ArrayList<TreeNode>(nodes);
        Collections.sort(nodes, this.myNodeComparator);
        ArrayList<TreeNode> all = TreeUtil.childrenToArray(parentNode);
        all.addAll(nodes);
        Collections.sort(all, this.myNodeComparator);
        int[] indices = new int[nodes.size()];
        int idx = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNode node = nodes.get(i);
            while (all.get(idx) != node) {
                ++idx;
            }
            indices[i] = idx;
            parentNode.insert((MutableTreeNode)node, idx);
        }
        this.myTreeModel.nodesWereInserted(parentNode, indices);
    }

    private void disposeNode(DefaultMutableTreeNode node) {
        if (node.getChildCount() > 0) {
            for (DefaultMutableTreeNode _node = (DefaultMutableTreeNode)node.getFirstChild(); _node != null; _node = _node.getNextSibling()) {
                this.disposeNode(_node);
            }
        }
        if (AbstractTreeBuilder.isLoadingNode(node)) {
            return;
        }
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        if (descriptor == null) {
            return;
        }
        Object element = descriptor.getElement();
        this.removeMapping(element, node);
        node.setUserObject(null);
        node.removeAllChildren();
    }

    public void addSubtreeToUpdate(DefaultMutableTreeNode root) {
        this.addSubtreeToUpdate(root, null);
    }

    public void addSubtreeToUpdate(DefaultMutableTreeNode root, Runnable runAfterUpdate) {
        this.myUpdater.runAfterUpdate(runAfterUpdate);
        this.myUpdater.addSubtreeToUpdate(root);
    }

    public boolean wasRootNodeInitialized() {
        return this.myRootNodeWasInitialized;
    }

    public void select(Object[] elements, @Nullable Runnable onDone) {
        int[] originalRows = this.myTree.getSelectionRows();
        this.myTree.clearSelection();
        this.addNext(elements, 0, onDone, originalRows);
    }

    private void addNext(final Object[] elements, final int i, final @Nullable Runnable onDone, final int[] originalRows) {
        if (i >= elements.length) {
            if (this.myTree.isSelectionEmpty()) {
                this.myTree.setSelectionRows(originalRows);
            }
            if (onDone != null) {
                onDone.run();
            }
        } else {
            this._select(elements[i], new Runnable(){

                public void run() {
                    AbstractTreeBuilder.this.addNext(elements, i + 1, onDone, originalRows);
                }
            }, true);
        }
    }

    public void select(Object element, @Nullable Runnable onDone) {
        this._select(element, onDone, false);
    }

    private void _select(final Object element, final Runnable onDone, final boolean addToSelection) {
        final Runnable _onDone = new Runnable(){

            public void run() {
                DefaultMutableTreeNode toSelect = AbstractTreeBuilder.this.getNodeForElement(element);
                if (toSelect == null) {
                    return;
                }
                int row = AbstractTreeBuilder.this.myTree.getRowForPath(new TreePath(toSelect.getPath()));
                TreeUtil.showAndSelect(AbstractTreeBuilder.this.myTree, row - 2, row + 2, row, -1, addToSelection);
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        if (this.wasRootNodeInitialized()) {
            this._expand(element, _onDone, true);
        } else {
            this.myDeferredSelections.add(new Runnable(){

                public void run() {
                    AbstractTreeBuilder.this._expand(element, _onDone, true);
                }
            });
        }
    }

    public void expand(Object element, @Nullable Runnable onDone) {
        this._expand(element, onDone == null ? new EmptyRunnable() : onDone, false);
    }

    private void _expand(Object element, @NotNull Runnable onDone, boolean parentsOnly) {
        DefaultMutableTreeNode firstVisible;
        ArrayList<Object> kidsToExpand;
        block4: {
            if (onDone == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeBuilder._expand must not be null");
            }
            kidsToExpand = new ArrayList<Object>();
            Object eachElement = element;
            do {
                firstVisible = this.getNodeForElement(eachElement);
                if (eachElement != element || !parentsOnly) {
                    kidsToExpand.add(eachElement);
                }
                if (firstVisible != null) break block4;
            } while ((eachElement = this.myTreeStructure.getParentElement(eachElement)) != null);
            firstVisible = null;
        }
        if (firstVisible == null) {
            onDone.run();
        }
        this.processExpand(firstVisible, kidsToExpand, kidsToExpand.size() - 1, onDone);
    }

    private void processExpand(DefaultMutableTreeNode toExpand, final List kidsToExpand, final int expandIndex, final @NotNull Runnable onDone) {
        if (onDone == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeBuilder.processExpand must not be null");
        }
        Object element = AbstractTreeBuilder.getElementFor(toExpand);
        if (element == null) {
            return;
        }
        this.addNodeAction(element, new NodeAction(){

            public void onReady(DefaultMutableTreeNode node) {
                if (node.getChildCount() >= 0 && !AbstractTreeBuilder.this.myTree.isExpanded(new TreePath(node.getPath()))) {
                    AbstractTreeBuilder.this.expand(node);
                }
                if (expandIndex < 0) {
                    onDone.run();
                    return;
                }
                DefaultMutableTreeNode nextNode = AbstractTreeBuilder.this.getNodeForElement(kidsToExpand.get(expandIndex));
                if (nextNode != null) {
                    AbstractTreeBuilder.this.processExpand(nextNode, kidsToExpand, expandIndex - 1, onDone);
                } else {
                    onDone.run();
                }
            }
        });
        this.expand(toExpand);
    }

    @Nullable
    private static Object getElementFor(DefaultMutableTreeNode node) {
        Object o;
        if (node != null && (o = node.getUserObject()) instanceof NodeDescriptor) {
            return ((NodeDescriptor)o).getElement();
        }
        return null;
    }

    public final boolean isNodeBeingBuilt(TreePath path) {
        return this.isNodeBeingBuilt(path.getLastPathComponent());
    }

    public final boolean isNodeBeingBuilt(Object nodeObject) {
        return this.isParentLoading(nodeObject) || this.isLoadingChildrenFor(nodeObject);
    }

    private void createMapping(Object element, DefaultMutableTreeNode node) {
        if (!this.myElementToNodeMap.containsKey(element)) {
            this.myElementToNodeMap.put(element, node);
        } else {
            ArrayList<DefaultMutableTreeNode> nodes;
            Object value = this.myElementToNodeMap.get(element);
            if (value instanceof DefaultMutableTreeNode) {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                nodes.add((DefaultMutableTreeNode)value);
                this.myElementToNodeMap.put(element, nodes);
            } else {
                nodes = (ArrayList<DefaultMutableTreeNode>)value;
            }
            nodes.add(node);
        }
    }

    private void removeMapping(Object element, DefaultMutableTreeNode node) {
        Object value = this.myElementToNodeMap.get(element);
        if (value == null) {
            return;
        }
        if (value instanceof DefaultMutableTreeNode) {
            if (value.equals(node)) {
                this.myElementToNodeMap.remove(element);
            }
        } else {
            List nodes = (List)value;
            boolean reallyRemoved = nodes.remove(node);
            if (reallyRemoved && nodes.isEmpty()) {
                this.myElementToNodeMap.remove(element);
            }
        }
    }

    private DefaultMutableTreeNode getFirstNode(Object element) {
        Object value = this.findNodeByElement(element);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)value;
        }
        List nodes = (List)value;
        return nodes.isEmpty() ? null : (DefaultMutableTreeNode)nodes.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findNodeByElement(Object element) {
        if (this.myElementToNodeMap.containsKey(element)) {
            return this.myElementToNodeMap.get(element);
        }
        try {
            this.TREE_NODE_WRAPPER.setValue(element);
            Object v = this.myElementToNodeMap.get(this.TREE_NODE_WRAPPER);
            return v;
        }
        finally {
            this.TREE_NODE_WRAPPER.setValue(null);
        }
    }

    private DefaultMutableTreeNode findNodeForChildElement(DefaultMutableTreeNode parentNode, Object element) {
        Object value = this.myElementToNodeMap.get(element);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode elementNode = (DefaultMutableTreeNode)value;
            return parentNode.equals(elementNode.getParent()) ? elementNode : null;
        }
        List allNodesForElement = (List)value;
        for (DefaultMutableTreeNode elementNode : allNodesForElement) {
            if (!parentNode.equals(elementNode.getParent())) continue;
            return elementNode;
        }
        return null;
    }

    public void cancelBackgroundLoading() {
        if (this.myWorker != null) {
            this.myWorker.cancelTasks();
        }
        this.myBackgroundableNodeActions.clear();
    }

    private void addNodeAction(Object element, NodeAction action) {
        List<NodeAction> list = this.myBackgroundableNodeActions.get(element);
        if (list == null) {
            list = new ArrayList<NodeAction>();
            this.myBackgroundableNodeActions.put(element, list);
        }
        list.add(action);
    }

    static interface NodeAction {
        public void onReady(DefaultMutableTreeNode var1);
    }

    public static class LoadingNode
    extends DefaultMutableTreeNode {
        public LoadingNode() {
            super(IdeBundle.message("treenode.loading", new Object[0]));
        }

        public LoadingNode(String text) {
            super(text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        public AbstractTreeNodeWrapper() {
            super((Project)null, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeBuilder$AbstractTreeNodeWrapper.getChildren must not return null");
            }
            return list;
        }

        @Override
        public void update(PresentationData presentation) {
        }
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            int n;
            TreePath path = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!AbstractTreeBuilder.this.myUnbuiltNodes.contains(node)) {
                return;
            }
            AbstractTreeBuilder.this.myUnbuiltNodes.remove(node);
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
            alarm.addRequest(new Runnable(){

                public void run() {
                    AbstractTreeBuilder.this.myTree.setCursor(Cursor.getPredefinedCursor(3));
                }
            }, 100);
            AbstractTreeBuilder.this.expandNodeChildren(node);
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!AbstractTreeBuilder.isLoadingNode(node.getChildAt(i))) continue;
                AbstractTreeBuilder.this.myTreeModel.removeNodeFromParent((MutableTreeNode)node.getChildAt(i));
                break;
            }
            if ((n = alarm.cancelAllRequests()) == 0) {
                AbstractTreeBuilder.this.myTree.setCursor(Cursor.getDefaultCursor());
            }
            AbstractTreeBuilder.this.processSmartExpand(node);
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.isSelectionInside(node)) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    public void run() {
                        if (AbstractTreeBuilder.this.myDisposed) {
                            return;
                        }
                        AbstractTreeBuilder.this.myTree.addSelectionPath(new TreePath(AbstractTreeBuilder.this.myTreeModel.getPathToRoot(node)));
                    }
                });
            }
            if (!(node.getUserObject() instanceof NodeDescriptor)) {
                return;
            }
            NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
            if (AbstractTreeBuilder.this.isDisposeOnCollapsing(descriptor)) {
                this.removeChildren(node);
                AbstractTreeBuilder.this.addLoadingNode(node);
                if (node.equals(AbstractTreeBuilder.this.myRootNode)) {
                    AbstractTreeBuilder.this.myTree.addSelectionPath(new TreePath(AbstractTreeBuilder.this.myRootNode.getPath()));
                } else {
                    AbstractTreeBuilder.this.myTreeModel.reload(node);
                }
            }
        }

        private void removeChildren(DefaultMutableTreeNode node) {
            EnumerationCopy copy = new EnumerationCopy(node.children());
            while (copy.hasMoreElements()) {
                AbstractTreeBuilder.this.disposeNode((DefaultMutableTreeNode)copy.nextElement());
            }
            node.removeAllChildren();
            AbstractTreeBuilder.this.myTreeModel.nodeStructureChanged(node);
        }

        private boolean isSelectionInside(DefaultMutableTreeNode parent) {
            TreePath path = new TreePath(AbstractTreeBuilder.this.myTreeModel.getPathToRoot(parent));
            TreePath[] paths = AbstractTreeBuilder.this.myTree.getSelectionPaths();
            if (paths == null) {
                return false;
            }
            for (TreePath path1 : paths) {
                if (!path.isDescendant(path1)) continue;
                return true;
            }
            return false;
        }
    }
}

