/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardContext {
    @Nullable
    private final Project myProject;
    private String myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private ProjectJdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private List<Listener> myListeners = new ArrayList<Listener>();

    public WizardContext(Project project) {
        this.myProject = project;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance(this.myProject).getProjectJdk();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getProjectFileDirectory() {
        String userHome;
        String lastProjectLocation;
        String string;
        if (!(this.myProjectFileDirectory != null ? (string = this.myProjectFileDirectory) != null : ((lastProjectLocation = GeneralSettings.getInstance().getLastProjectLocation()) != null ? (string = lastProjectLocation.replace('/', File.separatorChar)) != null : (string = (userHome = SystemProperties.getUserHome()).replace('/', File.separatorChar) + File.separator + ApplicationNamesInfo.getInstance().getLowercaseProductName() + "Projects") != null))) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/WizardContext.getProjectFileDirectory must not return null");
        }
        return string;
    }

    public void setProjectFileDirectory(String projectFileDirectory) {
        this.myProjectFileDirectory = projectFileDirectory;
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    public void requestWizardButtonsUpdate() {
        Listener[] listeners;
        for (Listener listener : listeners = this.myListeners.toArray(new Listener[this.myListeners.size()])) {
            listener.buttonsUpdateRequested();
        }
    }

    public void addContextListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeContextListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    public void setProjectJdk(ProjectJdk jdk) {
        this.myProjectJdk = jdk;
    }

    public ProjectJdk getProjectJdk() {
        return this.myProjectJdk;
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(ProjectBuilder projectBuilder) {
        this.myProjectBuilder = projectBuilder;
    }

    public String getPresentationName() {
        return this.myProject == null ? IdeBundle.message("project.new.wizard.project.identification", new Object[0]) : IdeBundle.message("project.new.wizard.module.identification", new Object[0]);
    }

    public static interface Listener {
        public void buttonsUpdateRequested();
    }
}

