/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleCircularDependencyException;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBuilder
extends ProjectBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.projectWizard.ModuleBuilder");
    private String myName;
    @NonNls
    private String myModuleFilePath;
    @Nullable
    private List<ModuleConfigurationUpdater> myUpdaters = new ArrayList<ModuleConfigurationUpdater>();
    private EventDispatcher<ModuleBuilderListener> myDispatcher = EventDispatcher.create(ModuleBuilderListener.class);

    @Nullable
    protected final String acceptParameter(String param) {
        return param != null && param.length() > 0 ? param : null;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = this.acceptParameter(name);
    }

    public String getModuleFilePath() {
        return this.myModuleFilePath;
    }

    public void addModuleConfigurationUpdater(ModuleConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    public void setModuleFilePath(@NonNls String path) {
        this.myModuleFilePath = this.acceptParameter(path);
    }

    @Nullable
    public String getModuleFileDirectory() {
        if (this.myModuleFilePath == null) {
            return null;
        }
        String parent = new File(this.myModuleFilePath).getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(File.separatorChar, '/');
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Module createModule(ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        LOG.assertTrue(this.myName != null);
        LOG.assertTrue(this.myModuleFilePath != null);
        ModuleType moduleType = this.getModuleType();
        Module module = moduleModel.newModule(this.myModuleFilePath, moduleType);
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(module).getModifiableModel();
        this.setupRootModel(modifiableModel);
        for (ModuleConfigurationUpdater updater : this.myUpdaters) {
            updater.update(module, modifiableModel);
        }
        modifiableModel.commit();
        module.setSavePathsRelative(true);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/ModuleBuilder.createModule must not return null");
        }
        return module2;
    }

    private void onModuleInitialized(Module module) {
        this.myDispatcher.getMulticaster().moduleCreated(module);
    }

    public abstract void setupRootModel(ModifiableRootModel var1) throws ConfigurationException;

    public abstract ModuleType getModuleType();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Module createAndCommit(ModifiableModuleModel moduleModel, boolean runFromProjectWizard) throws InvalidDataException, ConfigurationException, IOException, JDOMException, ModuleWithNameAlreadyExists, ModuleCircularDependencyException {
        final Module module = this.createModule(moduleModel);
        moduleModel.commit();
        if (runFromProjectWizard) {
            StartupManager.getInstance(module.getProject()).registerPostStartupActivity(new Runnable(){

                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        public void run() {
                            ModuleBuilder.this.onModuleInitialized(module);
                        }
                    });
                }
            });
        } else {
            this.onModuleInitialized(module);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/ModuleBuilder.createAndCommit must not return null");
        }
        return module2;
    }

    public void addListener(ModuleBuilderListener listener) {
        this.myDispatcher.addListener(listener);
    }

    public void removeListener(ModuleBuilderListener listener) {
        this.myDispatcher.removeListener(listener);
    }

    public boolean canCreateModule() {
        return true;
    }

    public void commit(final Project project) {
        if (this.canCreateModule()) {
            Exception ex;
            if (this.myName == null) {
                this.myName = project.getName();
            }
            if (this.myModuleFilePath == null) {
                this.myModuleFilePath = project.getBaseDir().getPath() + File.separator + this.myName + ".iml";
            }
            if ((ex = ApplicationManager.getApplication().runWriteAction(new Computable<Exception>(){

                @Override
                public Exception compute() {
                    try {
                        ModifiableModuleModel moduleModel = ModuleManager.getInstance(project).getModifiableModel();
                        ModuleBuilder.this.createAndCommit(moduleModel, true);
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
            })) != null) {
                Messages.showErrorDialog(IdeBundle.message("error.adding.module.to.project", ex.getMessage()), IdeBundle.message("title.add.module", new Object[0]));
            }
        }
    }

    public static abstract class ModuleConfigurationUpdater {
        public abstract void update(Module var1, ModifiableRootModel var2);
    }
}

