/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private String myContentEntryPath;
    private String myCompilerOutputPath;
    private List<Pair<String, String>> mySourcePaths;
    private List<Pair<String, String>> myModuleLibraries = new ArrayList<Pair<String, String>>();
    private ProjectJdk myJdk;

    @Override
    @Nullable
    public final String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    @Override
    public final void setContentEntryPath(String moduleRootPath) {
        String path = this.acceptParameter(moduleRootPath);
        if (path != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName(path);
            }
            catch (IOException e) {
                this.myContentEntryPath = path;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    public final void setCompilerOutputPath(String compilerOutputPath) {
        this.myCompilerOutputPath = this.acceptParameter(compilerOutputPath);
    }

    @Override
    public List<Pair<String, String>> getSourcePaths() {
        if (this.mySourcePaths == null) {
            ArrayList<Pair<String, String>> paths = new ArrayList<Pair<String, String>>();
            String path = this.getContentEntryPath() + File.separator + "src";
            new File(path).mkdirs();
            paths.add(Pair.create(path, ""));
            return paths;
        }
        return this.mySourcePaths;
    }

    @Override
    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
        this.mySourcePaths = sourcePaths != null ? new ArrayList<Pair<String, String>>(sourcePaths) : null;
    }

    @Override
    public void addSourcePath(Pair<String, String> sourcePathInfo) {
        if (this.mySourcePaths == null) {
            this.mySourcePaths = new ArrayList<Pair<String, String>>();
        }
        this.mySourcePaths.add(sourcePathInfo);
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.JAVA;
    }

    @Override
    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        LocalFileSystem lfs;
        VirtualFile moduleContentRoot;
        rootModel.setExcludeOutput(true);
        if (this.myJdk != null) {
            rootModel.setJdk(this.myJdk);
        } else {
            rootModel.inheritJdk();
        }
        String moduleRootPath = this.getContentEntryPath();
        if (moduleRootPath != null && (moduleContentRoot = (lfs = LocalFileSystem.getInstance()).refreshAndFindFileByPath(FileUtil.toSystemIndependentName(moduleRootPath))) != null) {
            ContentEntry contentEntry = rootModel.addContentEntry(moduleContentRoot);
            List<Pair<String, String>> sourcePaths = this.getSourcePaths();
            if (sourcePaths != null) {
                for (Pair<String, String> sourcePath : sourcePaths) {
                    VirtualFile sourceRoot = lfs.refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)sourcePath.first));
                    if (sourceRoot == null) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, (String)sourcePath.second);
                }
            }
        }
        if (this.myCompilerOutputPath != null) {
            String canonicalPath;
            try {
                canonicalPath = FileUtil.resolveShortWindowsName(this.myCompilerOutputPath);
            }
            catch (IOException e) {
                canonicalPath = this.myCompilerOutputPath;
            }
            rootModel.setCompilerOutputPath(VfsUtil.pathToUrl(FileUtil.toSystemIndependentName(canonicalPath)));
        } else {
            rootModel.inheritCompilerOutputPath(true);
        }
        LibraryTable libraryTable = rootModel.getModuleLibraryTable();
        for (Pair<String, String> libInfo : this.myModuleLibraries) {
            String moduleLibraryPath = (String)libInfo.first;
            String sourceLibraryPath = (String)libInfo.second;
            Library library = libraryTable.createLibrary();
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(moduleLibraryPath), OrderRootType.CLASSES);
            if (sourceLibraryPath != null) {
                modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(sourceLibraryPath), OrderRootType.SOURCES);
            }
            modifiableModel.commit();
        }
    }

    private static String getUrlByPath(String path) {
        return VfsUtil.getUrlForLibraryRoot(new File(path));
    }

    public void addModuleLibrary(String moduleLibraryPath, String sourcePath) {
        this.myModuleLibraries.add(Pair.create(moduleLibraryPath, sourcePath));
    }

    public void setModuleJdk(ProjectJdk jdk) {
        this.myJdk = jdk;
    }

    public ProjectJdk getModuleJdk() {
        return this.myJdk;
    }

    @Nullable
    protected static String getPathForOutputPathStep() {
        return null;
    }
}

