/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="UISettings", storages={@Storage(id="uilnf", file="$APP_CONFIG$/ui.lnf.xml")})
public class UISettings
implements PersistentStateComponent<UISettings>,
ExportableApplicationComponent {
    private EventListenerList myListenerList = new EventListenerList();
    @Property(filter=FontFilter.class)
    @NonNls
    public String FONT_FACE;
    @Property(filter=FontFilter.class)
    public int FONT_SIZE;
    public int RECENT_FILES_LIMIT = 15;
    public int EDITOR_TAB_LIMIT = 10;
    public boolean ANIMATE_WINDOWS = true;
    public int ANIMATION_SPEED = 2000;
    public boolean SHOW_WINDOW_SHORTCUTS = true;
    public boolean HIDE_TOOL_STRIPES = false;
    public boolean SHOW_MEMORY_INDICATOR = true;
    public boolean SHOW_MAIN_TOOLBAR = true;
    public boolean SHOW_STATUS_BAR = true;
    public boolean SHOW_NAVIGATION_BAR = true;
    public boolean ALWAYS_SHOW_WINDOW_BUTTONS = false;
    public boolean CYCLE_SCROLLING = true;
    public boolean SCROLL_TAB_LAYOUT_IN_EDITOR = false;
    public int EDITOR_TAB_PLACEMENT = 1;
    public boolean HIDE_KNOWN_EXTENSION_IN_TABS = false;
    public boolean SHOW_ICONS_IN_QUICK_NAVIGATION = true;
    public boolean CLOSE_NON_MODIFIED_FILES_FIRST = false;
    public boolean ACTIVATE_MRU_EDITOR_ON_CLOSE = false;
    public boolean ANTIALIASING_IN_EDITOR = SystemInfo.isMac;
    public boolean MOVE_MOUSE_ON_DEFAULT_BUTTON = false;
    public boolean ENABLE_ALPHA_MODE = false;
    public int ALPHA_MODE_DELAY = 1500;
    public float ALPHA_MODE_RATIO = 0.5f;
    public int MAX_CLIPBOARD_CONTENTS = 5;
    public boolean OVERRIDE_NONIDEA_LAF_FONTS = false;
    public boolean SHOW_ICONS_IN_MENUS = true;
    public boolean MARK_MODIFIED_TABS_WITH_ASTERISK = false;
    public static final int TABS_NONE = 0;

    public UISettings() {
        this.setSystemFontFaceAndSize();
    }

    public void addUISettingsListener(UISettingsListener listener) {
        this.myListenerList.add(UISettingsListener.class, listener);
    }

    public void fireUISettingsChanged() {
        UISettingsListener[] listeners;
        for (UISettingsListener listener : listeners = (UISettingsListener[])this.myListenerList.getListeners(UISettingsListener.class)) {
            listener.uiSettingsChanged(this);
        }
    }

    public static UISettings getInstance() {
        return ApplicationManager.getApplication().getComponent(UISettings.class);
    }

    public void removeUISettingsListener(UISettingsListener listener) {
        this.myListenerList.remove(UISettingsListener.class, listener);
    }

    private void setDefaultFontSettings() {
        this.FONT_FACE = "dialog";
        this.FONT_SIZE = 12;
    }

    private static boolean isValidFont(Font font) {
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setSystemFontFaceAndSize() {
        if (this.FONT_FACE == null || this.FONT_SIZE <= 0) {
            if (SystemInfo.isWindows) {
                Font font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
                if (font != null) {
                    this.FONT_FACE = font.getName();
                    this.FONT_SIZE = font.getSize();
                } else {
                    this.setDefaultFontSettings();
                }
            } else {
                this.setDefaultFontSettings();
            }
        }
    }

    private static boolean hasDefaultFontSetting(UISettings settings) {
        Font font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
        return SystemInfo.isWindows && font != null && settings.FONT_FACE.equals(font.getName()) && settings.FONT_SIZE == font.getSize();
    }

    @Override
    public UISettings getState() {
        return this;
    }

    @Override
    public void loadState(UISettings object) {
        XmlSerializerUtil.copyBean(object, this);
        if (this.EDITOR_TAB_PLACEMENT != 0 && this.EDITOR_TAB_PLACEMENT != 1 && this.EDITOR_TAB_PLACEMENT != 2 && this.EDITOR_TAB_PLACEMENT != 3 && this.EDITOR_TAB_PLACEMENT != 4) {
            this.EDITOR_TAB_PLACEMENT = 1;
        }
        if (this.ALPHA_MODE_DELAY < 0) {
            this.ALPHA_MODE_DELAY = 1500;
        }
        if (this.ALPHA_MODE_RATIO < 0.0f || this.ALPHA_MODE_RATIO > 1.0f) {
            this.ALPHA_MODE_RATIO = 0.5f;
        }
        this.setSystemFontFaceAndSize();
        boolean fontIsValid = UISettings.isValidFont(new Font(this.FONT_FACE, 0, this.FONT_SIZE));
        if (!fontIsValid) {
            String[] preferredFonts;
            for (String preferredFont : preferredFonts = new String[]{"dialog", "Arial", "Tahoma"}) {
                if (!UISettings.isValidFont(new Font(preferredFont, 0, this.FONT_SIZE))) continue;
                this.FONT_FACE = preferredFont;
                fontIsValid = true;
                break;
            }
            if (!fontIsValid) {
                Font[] fonts;
                for (Font font : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                    if (!UISettings.isValidFont(font)) continue;
                    this.FONT_FACE = font.getName();
                    break;
                }
            }
        }
        if (this.MAX_CLIPBOARD_CONTENTS <= 0) {
            this.MAX_CLIPBOARD_CONTENTS = 5;
        }
        this.fireUISettingsChanged();
    }

    public static void setupAntialiasing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        UISettings uiSettings = UISettings.getInstance();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (uiSettings.ANTIALIASING_IN_EDITOR) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                Object textAA = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
                if (RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT.equals(textAA)) {
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g2d.addRenderingHints(map);
                }
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile("ui.lnf")};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/ui/UISettings.getExportFiles must not return null");
        }
        return fileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message("ui.settings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/ui/UISettings.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getComponentName() {
        if ("UISettings" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/ui/UISettings.getComponentName must not return null");
        }
        return "UISettings";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
    }

    public static class FontFilter
    implements SerializationFilter {
        public boolean accepts(Accessor accessor, Object bean) {
            UISettings settings = (UISettings)bean;
            return !UISettings.hasDefaultFontSetting(settings);
        }
    }
}

