/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel {
    private final Editor myEditor;
    private final CaretListener myCaretListener;
    private final List<FileEditorPositionListener> myListeners;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/TextEditorBasedStructureViewModel.<init> must not be null");
        }
        this(TextEditorBasedStructureViewModel.getEditorForFile(psiFile));
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this.myListeners = new CopyOnWriteArrayList<FileEditorPositionListener>();
        this.myEditor = editor;
        this.myCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (Comparing.equal(e.getEditor(), TextEditorBasedStructureViewModel.this.myEditor)) {
                    this.fireCaretPositionChanged();
                }
            }

            private void fireCaretPositionChanged() {
                for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                    listener.onCurrentElementChanged();
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myCaretListener);
    }

    @Nullable
    private static Editor getEditorForFile(@NotNull PsiFile psiFile) {
        FileEditor[] editors;
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getEditorForFile must not be null");
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            PsiFile originalFile = psiFile.getOriginalFile();
            if (originalFile == null) {
                return null;
            }
            virtualFile = originalFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
        }
        for (FileEditor editor : editors = FileEditorManager.getInstance(psiFile.getProject()).getEditors(virtualFile)) {
            if (!(editor instanceof TextEditor)) continue;
            return ((TextEditor)editor).getEditor();
        }
        return null;
    }

    public final void addEditorPositionListener(FileEditorPositionListener listener) {
        this.myListeners.add(listener);
    }

    public final void removeEditorPositionListener(FileEditorPositionListener listener) {
        this.myListeners.remove(listener);
    }

    public void dispose() {
        EditorFactory.getInstance().getEventMulticaster().removeCaretListener(this.myCaretListener);
    }

    public Object getCurrentEditorElement() {
        if (this.myEditor == null) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        FileViewProvider viewProvider = this.getPsiFile().getViewProvider();
        for (PsiElement element = viewProvider.findElementAt(offset, this.getPsiFile().getLanguage()); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!this.isSuitable(element)) continue;
            return element;
        }
        return null;
    }

    protected abstract PsiFile getPsiFile();

    protected boolean isSuitable(PsiElement element) {
        Class[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionCache.isAssignable(suitableClass, element.getClass())) continue;
            return true;
        }
        return false;
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getSuitableClasses must not return null");
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }
}

