/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.startup.CacheUpdater;
import com.intellij.ide.startup.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ArrayBlockingQueue;
import org.jetbrains.annotations.NotNull;

public class FileSystemSynchronizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.startup.FileSystemSynchronizer");
    private ArrayList<CacheUpdater> myUpdaters = new ArrayList();
    private LinkedHashSet<VirtualFile> myFilesToUpdate = new LinkedHashSet();
    private Collection[] myUpdateSets;
    private boolean myIsCancelable = false;

    public void registerCacheUpdater(@NotNull CacheUpdater cacheUpdater) {
        if (cacheUpdater == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/startup/FileSystemSynchronizer.registerCacheUpdater must not be null");
        }
        this.myUpdaters.add(cacheUpdater);
    }

    public void setCancelable(boolean isCancelable) {
        this.myIsCancelable = isCancelable;
    }

    public void execute() {
        ProgressIndicator indicator;
        if (!this.myIsCancelable && (indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.startNonCancelableSection();
        }
        try {
            if (this.myUpdateSets == null && this.collectFilesToUpdate() == 0) {
                return;
            }
            this.updateFiles();
        }
        catch (ProcessCanceledException e) {
            for (CacheUpdater updater : this.myUpdaters) {
                if (updater == null) continue;
                updater.canceled();
            }
            throw e;
        }
        finally {
            ProgressIndicator indicator2;
            if (!this.myIsCancelable && (indicator2 = ProgressManager.getInstance().getProgressIndicator()) != null) {
                indicator2.finishNonCancelableSection();
            }
        }
    }

    public int collectFilesToUpdate() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.pushState();
            indicator.setText(IdeBundle.message("progress.scanning.files", new Object[0]));
        }
        this.myUpdateSets = new Collection[this.myUpdaters.size()];
        for (int i = 0; i < this.myUpdaters.size(); ++i) {
            CacheUpdater updater = this.myUpdaters.get(i);
            try {
                VirtualFile[] updaterFiles = updater.queryNeededFiles();
                LinkedHashSet<VirtualFile> localSet = new LinkedHashSet<VirtualFile>(Arrays.asList(updaterFiles));
                this.myFilesToUpdate.addAll(localSet);
                this.myUpdateSets[i] = localSet;
                continue;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                this.myUpdateSets[i] = new ArrayList();
            }
        }
        if (indicator != null) {
            indicator.popState();
        }
        if (this.myFilesToUpdate.isEmpty()) {
            this.updatingDone();
        }
        return this.myFilesToUpdate.size();
    }

    private void updateFiles() {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.pushState();
            indicator.setText(IdeBundle.message("progress.parsing.files", new Object[0]));
        }
        int totalFiles = this.myFilesToUpdate.size();
        final MyContentQueue contentQueue = new MyContentQueue();
        Runnable contentLoadingRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (VirtualFile file : FileSystemSynchronizer.this.myFilesToUpdate) {
                        if (indicator != null) {
                            indicator.checkCanceled();
                        }
                        contentQueue.put(file);
                    }
                }
                catch (ProcessCanceledException e) {
                }
                catch (InterruptedException e) {
                    LOG.error(e);
                }
                finally {
                    try {
                        contentQueue.put(new FileContent(null));
                    }
                    catch (InterruptedException e) {
                        LOG.error(e);
                    }
                }
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(contentLoadingRunnable);
        int count = 0;
        block8: while (true) {
            VirtualFile file;
            FileContent content = null;
            try {
                content = contentQueue.take();
            }
            catch (InterruptedException e) {
                LOG.error(e);
            }
            if (content == null || (file = content.getVirtualFile()) == null) break;
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setFraction((double)(++count) / (double)totalFiles);
                indicator.setText2(file.getPresentableUrl());
            }
            int i = 0;
            while (true) {
                if (i >= this.myUpdaters.size()) continue block8;
                CacheUpdater updater = this.myUpdaters.get(i);
                if (this.myUpdateSets[i].remove(file)) {
                    try {
                        updater.processFile(content);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                    if (this.myUpdateSets[i].isEmpty()) {
                        try {
                            updater.updatingDone();
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                        this.myUpdaters.set(i, null);
                    }
                }
                ++i;
            }
            break;
        }
        this.updatingDone();
        if (indicator != null) {
            indicator.popState();
        }
    }

    private void updatingDone() {
        for (CacheUpdater updater : this.myUpdaters) {
            try {
                if (updater == null) continue;
                updater.updatingDone();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        this.dropUpdaters();
    }

    private void dropUpdaters() {
        this.myUpdaters.clear();
        this.myFilesToUpdate.clear();
        this.myUpdateSets = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyContentQueue
    extends ArrayBlockingQueue<FileContent> {
        private long totalSize = 0L;
        private static final long SIZE_THRESHOLD = 0x100000L;

        public MyContentQueue() {
            super(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void put(VirtualFile file) throws InterruptedException {
            indicator = ProgressManager.getInstance().getProgressIndicator();
            var4_3 = this;
            synchronized (var4_3) {
                content = new FileContent(file);
                if (file.isValid()) {
                    try {
                        if (content.getPhysicalLength() >= 0x100000L) ** GOTO lbl28
                        while (this.totalSize > 0x100000L) {
                            if (indicator != null) {
                                indicator.checkCanceled();
                            }
                            this.wait(300L);
                        }
                        this.totalSize += (long)content.getPhysicalBytes().length;
                    }
                    catch (IOException e) {
                        content.setEmptyContent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        FileSystemSynchronizer.access$100().error(e);
                    }
                } else {
                    content.setEmptyContent();
                }
            }
lbl28:
            // 5 sources

            this.put(content);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileContent take() throws InterruptedException {
            FileContent result = (FileContent)super.take();
            MyContentQueue myContentQueue = this;
            synchronized (myContentQueue) {
                try {
                    VirtualFile file = result.getVirtualFile();
                    if (file == null || !file.isValid() || result.getPhysicalLength() >= 0x100000L) {
                        FileContent fileContent = result;
                        return fileContent;
                    }
                    this.totalSize -= (long)result.getPhysicalBytes().length;
                }
                catch (IOException e) {
                    LOG.error(e);
                }
                finally {
                    this.notifyAll();
                }
                return result;
            }
        }
    }
}

