/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class FileContent
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.startup.FileContent");
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private VirtualFile myVirtualFile;
    private byte[] myCachedBytes;
    private boolean myGetBytesCalled = false;
    private long myLength = -1L;

    public FileContent(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public byte[] getBytes() throws IOException {
        this.myGetBytesCalled = true;
        if (this.myCachedBytes == null) {
            this.myCachedBytes = this.myVirtualFile.contentsToByteArray();
        }
        return this.myCachedBytes;
    }

    public byte[] getPhysicalBytes() throws IOException {
        if (this.myGetBytesCalled) {
            LOG.error("getPhysicalBytes() called after getBytes() for " + this.myVirtualFile);
        }
        if (this.myCachedBytes == null) {
            this.myCachedBytes = LocalFileSystem.getInstance().physicalContentsToByteArray(this.myVirtualFile);
        }
        return this.myCachedBytes;
    }

    public void setEmptyContent() {
        this.myCachedBytes = EMPTY_CONTENT;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public long getPhysicalLength() throws IOException {
        if (this.myLength == -1L) {
            this.myLength = LocalFileSystem.getInstance().physicalLength(this.myVirtualFile);
        }
        return this.myLength;
    }
}

