/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectViewNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.projectView.ProjectViewNode");
    private ViewSettings mySettings;

    protected ProjectViewNode(Project project, Value value, ViewSettings viewSettings) {
        super(project, value);
        this.mySettings = viewSettings;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return false;
    }

    @Override
    public boolean isAlwaysExpand() {
        return false;
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    public final ViewSettings getSettings() {
        return this.mySettings;
    }

    public static List<AbstractTreeNode> wrap(Collection objects, Project project, Class<? extends AbstractTreeNode> nodeClass, ViewSettings settings) {
        try {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (Object object : objects) {
                result.add(ProjectViewNode.createTreeNode(nodeClass, project, object, settings));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error(e);
            return new ArrayList<AbstractTreeNode>();
        }
    }

    public static AbstractTreeNode createTreeNode(Class<? extends AbstractTreeNode> nodeClass, Project project, Object value, ViewSettings settings) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] parameters = new Object[]{project, value, settings};
        for (Constructor<?> constructor : nodeClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 3) continue;
            try {
                return (AbstractTreeNode)constructor.newInstance(parameters);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        throw new InstantiationException("no constructor found in " + nodeClass);
    }

    public boolean someChildContainsFile(VirtualFile file) {
        Collection<AbstractTreeNode> kids = this.getChildren();
        for (AbstractTreeNode kid : kids) {
            ProjectViewNode node = (ProjectViewNode)kid;
            if (!node.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasProblemFileBeneath() {
        return WolfTheProblemSolver.getInstance(this.getProject()).hasProblemFilesBeneath(this);
    }

    public boolean canHaveChildrenMatching(Condition<PsiFile> condition) {
        return true;
    }
}

