/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import javax.swing.Icon;

public class PresentationData
implements ItemPresentation {
    private Icon myClosedIcon;
    private Icon myOpenIcon;
    private String myLocationString;
    private String myPresentableText;
    private String myTooltip;
    private TextAttributesKey myAttributesKey;

    public PresentationData(String presentableText, String locationString, Icon openIcon, Icon closedIcon, TextAttributesKey attributesKey) {
        this.myClosedIcon = closedIcon;
        this.myLocationString = locationString;
        this.myOpenIcon = openIcon;
        this.myPresentableText = presentableText;
        this.myAttributesKey = attributesKey;
    }

    public PresentationData() {
    }

    public Icon getIcon(boolean open) {
        return open ? this.myOpenIcon : this.myClosedIcon;
    }

    public String getLocationString() {
        return this.myLocationString;
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    public void setClosedIcon(Icon closedIcon) {
        this.myClosedIcon = closedIcon;
    }

    public void setLocationString(String locationString) {
        this.myLocationString = locationString;
    }

    public void setOpenIcon(Icon openIcon) {
        this.myOpenIcon = openIcon;
    }

    public void setPresentableText(String presentableText) {
        this.myPresentableText = presentableText;
    }

    public void setIcons(Icon icon) {
        this.setClosedIcon(icon);
        this.setOpenIcon(icon);
    }

    public void updateFrom(ItemPresentation presentation) {
        this.setClosedIcon(presentation.getIcon(false));
        this.setOpenIcon(presentation.getIcon(true));
        this.setPresentableText(presentation.getPresentableText());
        this.setLocationString(presentation.getLocationString());
        this.setAttributesKey(presentation.getTextAttributesKey());
    }

    public TextAttributesKey getTextAttributesKey() {
        return this.myAttributesKey;
    }

    public void setAttributesKey(TextAttributesKey attributesKey) {
        this.myAttributesKey = attributesKey;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }
}

