/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateInPackageActionBase
extends CreateElementActionBase {
    protected CreateInPackageActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        DataContext dataContext = e.getDataContext();
        Project project = DataKeys.PROJECT.getData(dataContext);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            PsiDirectory[] dirs;
            IdeView view = DataKeys.IDE_VIEW.getData(dataContext);
            assert (view != null);
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            for (PsiDirectory dir : dirs = view.getDirectories()) {
                if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || !this.isGoodDir(dir)) continue;
                return;
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    protected boolean isGoodDir(PsiDirectory dir) {
        return dir.getPackage() != null;
    }

    protected final void checkBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = newName;
        if (newName.contains(".")) {
            dir = CreateInPackageActionBase.getTopLevelDir(dir);
            String[] names = newName.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String name = names[i];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    dir.checkCreateSubdirectory(name);
                    return;
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        this.doCheckCreate(dir, className);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final PsiElement[] create(String newName, PsiDirectory directory) throws IncorrectOperationException {
        PsiNameHelper helper = PsiManager.getInstance(directory.getProject()).getNameHelper();
        PsiPackage aPackage = directory.getPackage();
        String qualifiedName = aPackage.getQualifiedName();
        if (!StringUtil.isEmpty(qualifiedName) && !helper.isQualifiedName(qualifiedName)) {
            throw new IncorrectOperationException(this.getErrorTitle() + " in invalid package: '" + qualifiedName + "'");
        }
        PsiDirectory dir = directory;
        String className = newName;
        if (newName.contains(".")) {
            dir = CreateInPackageActionBase.getTopLevelDir(dir);
            String[] names = newName.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String name = names[i];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        PsiClass psiClass = this.doCreate(dir, className);
        PsiElement[] psiElementArray = new PsiElement[]{psiClass, psiClass.getLBrace()};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateInPackageActionBase.create must not return null");
        }
        return psiElementArray;
    }

    private static PsiDirectory getTopLevelDir(PsiDirectory dir) {
        while (dir.getPackage().getParentPackage() != null) {
            dir = dir.getParentDirectory();
        }
        return dir;
    }

    protected abstract void doCheckCreate(PsiDirectory var1, String var2) throws IncorrectOperationException;

    protected abstract PsiClass doCreate(PsiDirectory var1, String var2) throws IncorrectOperationException;
}

