/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateElementActionBase
extends AnAction {
    protected CreateElementActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(Project var1, PsiDirectory var2);

    protected abstract void checkBeforeCreate(String var1, PsiDirectory var2) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElement[] create(String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    public final void actionPerformed(AnActionEvent e) {
        PsiElement[] createdElements;
        DataContext dataContext = e.getDataContext();
        IdeView view = DataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = DataKeys.PROJECT.getData(dataContext);
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dir)) {
            view.selectElement(createdElement);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        Project project = DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        IdeView view = DataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || view.getDirectories().length == 0) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
    }

    protected static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        if (message.startsWith("java.io.IOException:")) {
            message = message.substring("java.io.IOException:".length());
        }
        return message;
    }

    protected class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final PsiDirectory myDirectory;
        private SmartPsiElementPointer[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            this.myProject = project;
            this.myDirectory = directory;
            this.myCreatedElements = new SmartPsiElementPointer[0];
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public boolean canClose(final String inputString) {
            if (inputString.length() == 0) {
                Messages.showMessageDialog(this.myProject, IdeBundle.message("error.name.should.be.specified", new Object[0]), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
                return false;
            }
            try {
                CreateElementActionBase.this.checkBeforeCreate(inputString, this.myDirectory);
            }
            catch (IncorrectOperationException e) {
                Messages.showMessageDialog(this.myProject, CreateElementActionBase.filterMessage(e.getMessage()), CreateElementActionBase.this.getErrorTitle(), Messages.getErrorIcon());
                return false;
            }
            final Exception[] exception = new Exception[1];
            Runnable command = new Runnable(){

                public void run() {
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            LocalHistoryAction action = LocalHistoryAction.NULL;
                            try {
                                action = LocalHistory.startAction(MyInputValidator.this.myProject, CreateElementActionBase.this.getActionName(MyInputValidator.this.myDirectory, inputString));
                                PsiElement[] psiElements = CreateElementActionBase.this.create(inputString, MyInputValidator.this.myDirectory);
                                MyInputValidator.access$202(MyInputValidator.this, new SmartPsiElementPointer[psiElements.length]);
                                SmartPointerManager manager = SmartPointerManager.getInstance(MyInputValidator.this.myProject);
                                for (int i = 0; i < MyInputValidator.this.myCreatedElements.length; ++i) {
                                    ((MyInputValidator)MyInputValidator.this).myCreatedElements[i] = manager.createSmartPsiElementPointer(psiElements[i]);
                                }
                            }
                            catch (Exception ex) {
                                exception[0] = ex;
                            }
                            finally {
                                action.finish();
                            }
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(run);
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, command, CreateElementActionBase.this.getCommandName(), null);
            if (exception[0] != null) {
                String errorMessage = CreateElementActionBase.filterMessage(exception[0].getMessage());
                if (errorMessage == null || errorMessage.length() == 0) {
                    errorMessage = exception[0].toString();
                }
                Messages.showMessageDialog(this.myProject, errorMessage, CreateElementActionBase.this.getErrorTitle(), Messages.getErrorIcon());
            }
            return this.myCreatedElements.length != 0;
        }

        public final PsiElement[] getCreatedElements() {
            ArrayList elts = new ArrayList();
            for (SmartPsiElementPointer pointer : this.myCreatedElements) {
                Object elt = pointer.getElement();
                if (elt == null) continue;
                elts.add(elt);
            }
            return elts.toArray(new PsiElement[elts.size()]);
        }

        static /* synthetic */ SmartPsiElementPointer[] access$202(MyInputValidator x0, SmartPsiElementPointer[] x1) {
            x0.myCreatedElements = x1;
            return x1;
        }
    }
}

