/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateInPackageActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassAction
extends CreateInPackageActionBase {
    public CreateClassAction() {
        super(IdeBundle.message("action.create.new.class", new Object[0]), IdeBundle.message("action.create.new.class", new Object[0]), Icons.CLASS_ICON);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator(this, project, directory);
        Messages.showInputDialog(project, IdeBundle.message("prompt.enter.new.class.name", new Object[0]), IdeBundle.message("title.new.class", new Object[0]), Messages.getQuestionIcon(), "", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateClassAction.invokeDialog must not return null");
        }
        return psiElementArray;
    }

    protected String getCommandName() {
        return IdeBundle.message("command.create.class", new Object[0]);
    }

    protected String getErrorTitle() {
        return IdeBundle.message("title.cannot.create.class", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message("progress.creating.class", directory.getPackage().getQualifiedName(), newName);
    }

    protected void doCheckCreate(PsiDirectory dir, String className) throws IncorrectOperationException {
        dir.checkCreateClass(className);
    }

    protected PsiClass doCreate(PsiDirectory dir, String className) throws IncorrectOperationException {
        return dir.createClass(className);
    }
}

