/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.pom.Navigatable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class OccurenceNavigatorSupport
implements OccurenceNavigator {
    private JTree myTree;

    public OccurenceNavigatorSupport(JTree tree) {
        this.myTree = tree;
    }

    @Nullable
    protected abstract Navigatable createDescriptorForNode(DefaultMutableTreeNode var1);

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        Counters counters = new Counters();
        DefaultMutableTreeNode node = this.findNode(this.myTree, true, counters);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        Counters counters = new Counters();
        DefaultMutableTreeNode node = this.findNode(this.myTree, false, counters);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    public boolean hasNextOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, true, null);
        return node != null;
    }

    public boolean hasPreviousOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, false, null);
        return node != null;
    }

    protected DefaultMutableTreeNode findNode(JTree tree, boolean forward, Counters counters) {
        DefaultMutableTreeNode nextNode;
        TreeNode node;
        int i;
        TreePath selectionPath = tree.getSelectionPath();
        TreeNode selectedNode = null;
        boolean[] ready = new boolean[]{true};
        if (selectionPath != null) {
            selectedNode = (TreeNode)selectionPath.getLastPathComponent();
            ready[0] = false;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = root.preorderEnumeration();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        while (enumeration.hasMoreElements()) {
            TreeNode node2 = enumeration.nextElement();
            nodes.add(node2);
        }
        DefaultMutableTreeNode result = null;
        if (forward) {
            for (i = 0; i < nodes.size(); ++i) {
                node = (TreeNode)nodes.get(i);
                nextNode = this.getNode(node, selectedNode, ready);
                if (nextNode == null) continue;
                result = nextNode;
                break;
            }
        } else {
            for (i = nodes.size() - 1; i >= 0; --i) {
                node = (TreeNode)nodes.get(i);
                nextNode = this.getNode(node, selectedNode, ready);
                if (nextNode == null) continue;
                result = nextNode;
                break;
            }
        }
        if (result == null) {
            return null;
        }
        if (counters != null) {
            counters.myFoundOccurenceNumber = 0;
            counters.myOccurencesCount = 0;
            for (i = 0; i < nodes.size(); ++i) {
                Navigatable descriptor;
                node = (TreeNode)nodes.get(i);
                if (!(node instanceof DefaultMutableTreeNode) || (descriptor = this.createDescriptorForNode((DefaultMutableTreeNode)node)) == null) continue;
                ++counters.myOccurencesCount;
                if (result != node) continue;
                counters.myFoundOccurenceNumber = counters.myOccurencesCount;
            }
        }
        return result;
    }

    protected DefaultMutableTreeNode getNode(TreeNode node, TreeNode selectedNode, boolean[] ready) {
        if (!ready[0]) {
            if (node == selectedNode) {
                ready[0] = true;
            }
            return null;
        }
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Navigatable descriptor = this.createDescriptorForNode((DefaultMutableTreeNode)node);
        if (descriptor == null) {
            return null;
        }
        return (DefaultMutableTreeNode)node;
    }

    protected static class Counters {
        public int myFoundOccurenceNumber;
        public int myOccurencesCount;

        protected Counters() {
        }
    }
}

