/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class BrowserUtil {
    @NonNls
    private static Pattern ourExternalPrefix = Pattern.compile("^[\\w\\+\\.\\-]{2,}:");
    private static Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(url.toLowerCase()).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorsuffix.matcher(url);
        if (anchorMatcher.find()) {
            return anchorMatcher.reset().replaceAll("");
        }
        return url;
    }

    public static URL getURL(String url) throws MalformedURLException {
        if (!BrowserUtil.isAbsoluteURL(url)) {
            return new URL("file", "", url);
        }
        return VfsUtil.convertToURL(url);
    }

    private static void launchBrowser(String url, String[] command) {
        try {
            URL curl = BrowserUtil.getURL(url);
            if (curl != null) {
                String[] commandLine;
                String urlString = curl.toString();
                if (SystemInfo.isWindows && BrowserUtil.isUseDefaultBrowser()) {
                    commandLine = new String[command.length + 2];
                    System.arraycopy(command, 0, commandLine, 0, command.length);
                    commandLine[commandLine.length - 2] = "\"\"";
                    commandLine[commandLine.length - 1] = "\"" + BrowserUtil.redirectUrl(url, urlString) + "\"";
                } else {
                    commandLine = new String[command.length + 1];
                    System.arraycopy(command, 0, commandLine, 0, command.length);
                    commandLine[commandLine.length - 1] = SystemInfo.isWindows ? "\"" + urlString + "\"" : urlString.replaceAll(" ", "%20");
                }
                Runtime.getRuntime().exec(commandLine);
            } else {
                BrowserUtil.showErrorMessage(IdeBundle.message("error.malformed.url", url), CommonBundle.getErrorTitle());
            }
        }
        catch (IOException e) {
            BrowserUtil.showErrorMessage(IdeBundle.message("error.cannot.start.browser", e.getMessage()), CommonBundle.getErrorTitle());
        }
    }

    private static String redirectUrl(String url, @NonNls String urlString) throws IOException {
        if (!(url.indexOf(38) != -1 || urlString.startsWith("file:") && urlString.indexOf("#") != -1)) {
            return urlString;
        }
        File redirect = File.createTempFile("redirect", ".html");
        redirect.deleteOnExit();
        FileWriter writer = new FileWriter(redirect);
        writer.write("<html><head></head><body><script type=\"text/javascript\">window.location=\"" + url + "\";</script></body></html>");
        writer.close();
        return VfsUtil.pathToUrl(redirect.getAbsolutePath());
    }

    private static boolean isUseDefaultBrowser() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return true;
        }
        return GeneralSettings.getInstance().isUseDefaultBrowser();
    }

    private static void showErrorMessage(final String message, final String title) {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Messages.showMessageDialog(message, title, Messages.getErrorIcon());
            }
        };
        if (app.isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    private static void launchBrowserUsingStandardWay(String url) {
        String[] command;
        block3: {
            try {
                String browserPath = GeneralSettings.getInstance().getBrowserPath();
                if (browserPath == null || browserPath.trim().length() == 0) {
                    BrowserUtil.showErrorMessage(IdeBundle.message("error.please.specify.path.to.web.browser", new Object[0]), IdeBundle.message("title.browser.not.found", new Object[0]));
                    return;
                }
                command = new String[]{browserPath};
            }
            catch (NullPointerException e) {
                command = BrowserUtil.getDefaultBrowserCommand(null);
                if (command != null) break block3;
                BrowserUtil.showErrorMessage(IdeBundle.message("error.please.open.url.manually", url, ApplicationNamesInfo.getInstance().getProductName()), IdeBundle.message("title.browser.path.not.found", new Object[0]));
                return;
            }
        }
        BrowserUtil.launchBrowser(url, command);
    }

    public static void launchBrowser(String url, String name) {
        if (url.startsWith("jar:")) {
            BrowserUtil.showErrorMessage(IdeBundle.message("error.cannot.show.in.external.browser", url), IdeBundle.message("title.cannot.start.browser", new Object[0]));
            return;
        }
        if (BrowserUtil.canStartDefaultBrowser() && BrowserUtil.isUseDefaultBrowser()) {
            BrowserUtil.launchBrowser(url, BrowserUtil.getDefaultBrowserCommand(name));
        } else {
            BrowserUtil.launchBrowserUsingStandardWay(url);
        }
    }

    public static void launchBrowser(@NonNls String url) {
        BrowserUtil.launchBrowser(url, (String)null);
    }

    @NonNls
    private static String[] getDefaultBrowserCommand(String name) {
        if (SystemInfo.isWindows9x) {
            return new String[]{"command.com", "/c", "start"};
        }
        if (SystemInfo.isWindows) {
            return new String[]{"cmd.exe", "/c", "start"};
        }
        if (SystemInfo.isMac) {
            return new String[]{"open"};
        }
        if (SystemInfo.isUnix) {
            return new String[]{"mozilla"};
        }
        return null;
    }

    public static boolean canStartDefaultBrowser() {
        if (SystemInfo.isMac) {
            return true;
        }
        return SystemInfo.isWindows;
    }
}

