/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history;

import com.intellij.history.Checkpoint;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class LocalHistory
implements SettingsSavingComponent {
    public static LocalHistoryAction startAction(Project p, String name) {
        return LocalHistory.getInstance(p).startAction(name);
    }

    public static void putUserLabel(Project p, String name) {
        LocalHistory.getInstance(p).putUserLabel(name);
    }

    public static void putUserLabel(Project p, VirtualFile f, String name) {
        LocalHistory.getInstance(p).putUserLabel(f, name);
    }

    public static void putSystemLabel(Project p, String name) {
        LocalHistory.getInstance(p).putSystemLabel(name, -1);
    }

    public static void putSystemLabel(Project p, String name, int color) {
        LocalHistory.getInstance(p).putSystemLabel(name, color);
    }

    public static Checkpoint putCheckpoint(Project p) {
        return LocalHistory.getInstance(p).putCheckpoint();
    }

    public static byte[] getByteContent(Project p, VirtualFile f, FileRevisionTimestampComparator c) {
        return LocalHistory.getInstance(p).getByteContent(f, c);
    }

    public static boolean isUnderControl(Project p, VirtualFile f) {
        return LocalHistory.getInstance(p).isUnderControl(f);
    }

    public static boolean hasUnavailableContent(Project p, VirtualFile f) {
        return LocalHistory.getInstance(p).hasUnavailableContent(f);
    }

    private static LocalHistory getInstance(Project p) {
        return p.getComponent(LocalHistory.class);
    }

    protected abstract LocalHistoryAction startAction(String var1);

    protected abstract void putUserLabel(String var1);

    protected abstract void putUserLabel(VirtualFile var1, String var2);

    protected abstract void putSystemLabel(String var1, int var2);

    protected abstract Checkpoint putCheckpoint();

    protected abstract byte[] getByteContent(VirtualFile var1, FileRevisionTimestampComparator var2);

    protected abstract boolean isUnderControl(VirtualFile var1);

    protected abstract boolean hasUnavailableContent(VirtualFile var1);
}

