/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public abstract class FindManager {
    public static final Topic<FindModelListener> FIND_MODEL_TOPIC = new Topic<FindModelListener>("FindManager's model changes", FindModelListener.class);

    public static FindManager getInstance(Project project) {
        return project.getComponent(FindManager.class);
    }

    public abstract boolean showFindDialog(FindModel var1);

    public abstract int showPromptDialog(FindModel var1, String var2);

    @NotNull
    public abstract FindModel getFindInFileModel();

    @NotNull
    public abstract FindModel getFindInProjectModel();

    @NotNull
    public abstract FindResult findString(CharSequence var1, int var2, FindModel var3);

    public abstract String getStringToReplace(String var1, FindModel var2);

    public abstract boolean findWasPerformed();

    public abstract void setFindWasPerformed();

    public abstract void setFindNextModel(FindModel var1);

    public abstract FindModel getFindNextModel();

    public abstract FindModel getFindNextModel(Editor var1);

    public abstract boolean canFindUsages(@NotNull PsiElement var1);

    public abstract void findUsages(@NotNull PsiElement var1);

    public abstract void findUsagesInEditor(@NotNull PsiElement var1, FileEditor var2);

    public abstract boolean findNextUsageInEditor(FileEditor var1);

    public abstract boolean findPreviousUsageInEditor(FileEditor var1);

    public static interface PromptResult {
        public static final int OK = 0;
        public static final int CANCEL = 1;
        public static final int SKIP = 2;
        public static final int ALL = 3;
        public static final int ALL_IN_THIS_FILE = 4;
        public static final int ALL_FILES = 5;
    }
}

