/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryInfo {
    public static final LibraryInfo[] EMPTY_ARRAY = new LibraryInfo[0];
    @Nullable
    private LibraryDownloadInfo myDownloadInfo;
    @NonNls
    private String myPresentableName;
    @NonNls
    private String[] myRequiredClasses;

    public LibraryInfo(@NonNls String presentableName, @Nullable @NonNls String version, @Nullable @NonNls String downloadingUrl, @Nullable String presentableUrl, String ... requiredClasses) {
        this.myPresentableName = presentableName;
        this.myRequiredClasses = requiredClasses;
        if (downloadingUrl != null) {
            int dot = presentableName.lastIndexOf(46);
            String prefix = presentableName.substring(0, dot);
            String suffix = presentableName.substring(dot);
            this.myDownloadInfo = new LibraryDownloadInfo(downloadingUrl, presentableUrl, prefix, suffix);
        }
    }

    public LibraryInfo(@NonNls String presentableName, @Nullable LibraryDownloadInfo downloadInfo, String ... requiredClasses) {
        this.myPresentableName = presentableName;
        this.myRequiredClasses = requiredClasses;
        this.myDownloadInfo = downloadInfo;
    }

    @NonNls
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NonNls
    public String[] getRequiredClasses() {
        return this.myRequiredClasses;
    }

    @Nullable
    public LibraryDownloadInfo getDownloadingInfo() {
        return this.myDownloadInfo;
    }
}

