/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadInfo {
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    private final String myPresentableUrl;

    public LibraryDownloadInfo(@NotNull RemoteRepositoryInfo remoteRepository, @NotNull @NonNls String relativeDownloadUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (remoteRepository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (relativeDownloadUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this(downloadUrl, null, fileNamePrefix);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDownloadUrl() {
        String string = this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getDownloadUrl must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDownloadUrl(String mirror) {
        String string = mirror + this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getDownloadUrl must not return null");
        }
        return string;
    }

    @Nullable
    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFileNamePrefix() {
        String string = this.myFileNamePrefix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getFileNamePrefix must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFileNameSuffix() {
        String string = this.myFileNameSuffix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getFileNameSuffix must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPresentableUrl() {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getPresentableUrl must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPresentableUrl(String mirror) {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getPresentableUrl must not return null");
        }
        return string;
    }
}

