/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacetType<F extends Facet, C extends FacetConfiguration> {
    @NotNull
    private final FacetTypeId<F> myId;
    @NotNull
    private final String myStringId;
    @NotNull
    private final String myPresentableName;
    @Nullable
    private final FacetTypeId myUnderlyingFacetType;

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName, @Nullable FacetTypeId underlyingFacetType) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        if (stringId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        if (presentableName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        this.myId = id;
        this.myStringId = stringId;
        this.myPresentableName = presentableName;
        this.myUnderlyingFacetType = underlyingFacetType;
    }

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        if (stringId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        if (presentableName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/FacetType.<init> must not be null");
        }
        this(id, stringId, presentableName, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final FacetTypeId<F> getId() {
        FacetTypeId<F> facetTypeId = this.myId;
        if (facetTypeId == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/FacetType.getId must not return null");
        }
        return facetTypeId;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getStringId() {
        String string = this.myStringId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/FacetType.getStringId must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/FacetType.getPresentableName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    @NonNls
    public String getDefaultFacetName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/FacetType.getDefaultFacetName must not return null");
        }
        return string;
    }

    @Nullable
    public final FacetTypeId<?> getUnderlyingFacetType() {
        return this.myUnderlyingFacetType;
    }

    public void registerDetectors(FacetDetectorRegistry<C> registry) {
    }

    public abstract C createDefaultConfiguration();

    public abstract F createFacet(@NotNull Module var1, String var2, @NotNull C var3, @Nullable Facet var4);

    public boolean isOnlyOneFacetAllowed() {
        return true;
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType == ModuleType.JAVA;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }
}

